/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra.util;

import com.sun.messaging.jmq.jmsclient.XAResourceMap;
import com.sun.messaging.jmq.util.XidImpl;
import com.sun.messaging.jms.ra.DirectXAResource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.xa.XAException;

public class DirectXAResourceMap {
    public static final int MAXROLLBACKS = XAResourceMap.MAXROLLBACKS;
    public static final boolean DMQ_ON_MAXROLLBACKS = XAResourceMap.DMQ_ON_MAXROLLBACKS;
    private static HashMap<XidImpl, Set<DirectXAResource>> resourceMap = new HashMap();

    public static synchronized void register(XidImpl xid, DirectXAResource xar, boolean isJoin) throws XAException {
        Set<DirectXAResource> resources = resourceMap.get(xid);
        if (resources == null) {
            if (isJoin) {
                XAException xae = new XAException("Trying to add an XAResource using the JOIN flag when no existing XAResource has been added with this XID");
                xae.errorCode = -5;
                throw xae;
            }
            resources = new HashSet<DirectXAResource>();
            resourceMap.put(xid, resources);
        } else if (!isJoin) {
            XAException xae = new XAException("Trying to add an XAResource to an existing xid without using the JOIN flag");
            xae.errorCode = -8;
            throw xae;
        }
        resources.add(xar);
    }

    public static synchronized void unregister(XidImpl xid) {
        resourceMap.remove(xid);
    }

    public static synchronized void unregisterResource(DirectXAResource xar, XidImpl xid) {
        Set<DirectXAResource> resources = resourceMap.get(xid);
        if (resources != null) {
            resources.remove(xar);
            if (resources.isEmpty()) {
                resourceMap.remove(xid);
            }
        }
    }

    public static synchronized DirectXAResource[] getXAResources(XidImpl xid, boolean throwExceptionIfNotFound) throws XAException {
        Set<DirectXAResource> resources = resourceMap.get(xid);
        if (resources == null) {
            if (throwExceptionIfNotFound) {
                XAException xae = new XAException("Unknown XID (was start() called?");
                throw xae;
            }
            return new DirectXAResource[0];
        }
        return resources.toArray(new DirectXAResource[resources.size()]);
    }

    public static boolean isEmpty() {
        return resourceMap.isEmpty();
    }
}

