/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.CommDBManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

class MySQLBrokerDAOImpl
extends BrokerDAOImpl {
    protected static String PROC_IS_BEING_TAKENOVER = null;
    private final String dropStoredProcSQL;

    MySQLBrokerDAOImpl() throws BrokerException {
        PROC_IS_BEING_TAKENOVER = "MQ410SP0BKR500" + DBManager.getDBManager().getTableSuffix();
        this.dropStoredProcSQL = new StringBuilder(128).append("DROP PROCEDURE IF EXISTS ").append(PROC_IS_BEING_TAKENOVER).toString();
    }

    @Override
    public void createStoredProc(Connection conn) throws BrokerException {
        block19: {
            Statement stmt;
            Exception myex;
            block18: {
                boolean myConn = false;
                myex = null;
                String sql = "";
                stmt = null;
                DBManager dbMgr = DBManager.getDBManager();
                if (conn == null) {
                    conn = dbMgr.getConnection(true);
                    myConn = true;
                }
                sql = new StringBuilder(128).append("CREATE PROCEDURE ").append(PROC_IS_BEING_TAKENOVER).append("( IN brokerID VARCHAR (100), OUT status INT, OUT state INT )").append(" BEGIN ").append(" SET status=0; ").append("SELECT ").append("STATE").append(" INTO state ").append("FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ").append("brokerID; ").append(" IF state=").append(9).append(" OR state=").append(7).append(" OR state=").append(8).append(" OR state=").append(10).append(" THEN ").append(" SET status=1; ").append(" END IF; ").append("END;").toString();
                stmt = conn.createStatement();
                try {
                    DBManager.executeUpdateStatement(stmt, sql);
                }
                catch (SQLException ee) {
                    int ec = ee.getErrorCode();
                    String et = ee.getSQLState();
                    if (ec != 1304 || et != null && !et.equals("42000")) {
                        throw ee;
                    }
                    this.logger.log(8, this.br.getKString("B1429", PROC_IS_BEING_TAKENOVER));
                    if (myConn) {
                        this.closeSQLObjects(null, stmt, conn, myex);
                    } else {
                        this.closeSQLObjects(null, stmt, null, myex);
                    }
                    return;
                }
                try {
                    Globals.getLogger().log(8, this.br.getKString("B1428", PROC_IS_BEING_TAKENOVER));
                    if (DEBUG) {
                        Globals.getLogger().log(8, sql);
                    }
                    if (!myConn) break block18;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? CommDBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
                        throw new BrokerException("Failed to execute " + sql, ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            this.closeSQLObjects(null, stmt, conn, myex);
                        } else {
                            this.closeSQLObjects(null, stmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                this.closeSQLObjects(null, stmt, conn, myex);
                break block19;
            }
            this.closeSQLObjects(null, stmt, null, myex);
        }
    }

    @Override
    public void dropStoredProc(Connection conn) throws BrokerException {
        boolean myConn = false;
        Exception myex = null;
        String sql = this.dropStoredProcSQL;
        Statement stmt = null;
        try {
            DBManager dbMgr = DBManager.getDBManager();
            if (conn == null) {
                conn = dbMgr.getConnection(true);
                myConn = true;
            }
            stmt = conn.createStatement();
            DBManager.executeStatement(stmt, sql);
            if (DEBUG) {
                Globals.getLogger().log(8, "DONE " + sql);
            }
        }
        catch (Exception e) {
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080", (Throwable)rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            Exception ex = e instanceof SQLException ? CommDBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
            throw new BrokerException("Failed to execute " + sql, ex);
        }
        finally {
            if (myConn) {
                this.closeSQLObjects(null, stmt, conn, myex);
            } else {
                this.closeSQLObjects(null, stmt, null, myex);
            }
        }
    }
}

