/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.jboss.logging.annotations.Field;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.Pos;
import org.jboss.logging.annotations.Property;
import org.jboss.logging.annotations.Transform;
import org.jboss.logging.processor.apt.AbstractClassType;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.util.Comparison;
import org.jboss.logging.processor.util.ElementHelper;
import org.jboss.logging.processor.util.Objects;

final class ParameterFactory {
    private ParameterFactory() {
    }

    public static Set<Parameter> of(ProcessingEnvironment processingEnv, ExecutableElement method) {
        Types types = processingEnv.getTypeUtils();
        LinkedHashSet<Parameter> result = new LinkedHashSet<Parameter>();
        List<? extends VariableElement> params = method.getParameters();
        int index = 0;
        for (VariableElement variableElement : params) {
            String qualifiedType;
            String formatClass;
            TypeElement formatClassType = ElementHelper.getClassAnnotationValue(variableElement, FormatWith.class);
            String string = formatClass = formatClassType == null ? null : formatClassType.getQualifiedName().toString();
            if (variableElement.asType().getKind().isPrimitive()) {
                qualifiedType = variableElement.asType().toString();
            } else {
                switch (variableElement.asType().getKind()) {
                    case ARRAY: {
                        qualifiedType = variableElement.asType().toString().replace("[]", "");
                        break;
                    }
                    default: {
                        qualifiedType = types.asElement(variableElement.asType()).toString();
                    }
                }
            }
            if (method.isVarArgs()) {
                result.add(new AptParameter(processingEnv, qualifiedType, variableElement, formatClass, ++index == params.size()));
                continue;
            }
            result.add(new AptParameter(processingEnv, qualifiedType, variableElement, formatClass, false));
        }
        return result;
    }

    public static Parameter forMessageMethod(MessageMethod messageMethod) {
        return new MessageMethodParameter(messageMethod);
    }

    private static class MessageMethodParameter
    implements Parameter {
        private final MessageMethod messageMethod;

        private MessageMethodParameter(MessageMethod messageMethod) {
            this.messageMethod = messageMethod;
        }

        @Override
        public Element getDelegate() {
            return this.messageMethod;
        }

        @Override
        public String formatterClass() {
            return null;
        }

        @Override
        public String targetName() {
            return "";
        }

        @Override
        public String name() {
            return this.messageMethod.messageMethodName();
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public boolean isVarArgs() {
            return false;
        }

        @Override
        public boolean isMessageMethod() {
            return true;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.messageMethod);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MessageMethodParameter)) {
                return false;
            }
            MessageMethodParameter other = (MessageMethodParameter)obj;
            return Objects.equals(this.messageMethod, other.messageMethod);
        }

        @Override
        public int compareTo(Parameter other) {
            if (other instanceof MessageMethodParameter) {
                MessageMethodParameter otherParameter = (MessageMethodParameter)other;
                return this.messageMethod.compareTo(otherParameter.messageMethod);
            }
            return Comparison.begin().compare((Comparable<?>)((Object)this.asType().toString()), (Comparable<?>)((Object)other.asType().toString())).compare((Comparable<?>)((Object)this.name()), (Comparable<?>)((Object)other.name())).result();
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add("name", this.name()).add("type", this.asType()).toString();
        }

        @Override
        public boolean isAssignableFrom(Class<?> type) {
            return false;
        }

        @Override
        public boolean isSubtypeOf(Class<?> type) {
            return false;
        }

        @Override
        public boolean isSameAs(Class<?> type) {
            return false;
        }
    }

    private static class AptParameter
    extends AbstractClassType
    implements Parameter {
        private final VariableElement param;
        private final String qualifiedType;
        private final String formatterClass;
        private final boolean isVarArgs;
        private final boolean isFormatArg;

        AptParameter(ProcessingEnvironment processingEnv, String qualifiedType, VariableElement param, String formatterClass, boolean isVarArgs) {
            super(processingEnv, param);
            this.qualifiedType = qualifiedType;
            this.param = param;
            this.formatterClass = formatterClass;
            this.isVarArgs = isVarArgs;
            this.isFormatArg = param.getAnnotationMirrors().isEmpty() || ElementHelper.isAnnotatedWith(param, FormatWith.class) || ElementHelper.isAnnotatedWith(param, Transform.class) || ElementHelper.isAnnotatedWith(param, Pos.class);
        }

        @Override
        public String formatterClass() {
            return this.formatterClass;
        }

        @Override
        public String name() {
            return this.param.getSimpleName().toString();
        }

        @Override
        public boolean isArray() {
            return this.param.asType().getKind() == TypeKind.ARRAY;
        }

        @Override
        public boolean isPrimitive() {
            return this.param.asType().getKind().isPrimitive();
        }

        @Override
        public boolean isVarArgs() {
            return this.isVarArgs;
        }

        @Override
        public boolean isFormatParameter() {
            return this.isFormatArg;
        }

        @Override
        public String targetName() {
            String result = "";
            Field field = this.param.getAnnotation(Field.class);
            Property property = this.param.getAnnotation(Property.class);
            if (field != null) {
                String name = field.name();
                result = name.isEmpty() ? this.param.getSimpleName().toString() : name;
            } else if (property != null) {
                String name = property.name();
                result = name.isEmpty() ? this.param.getSimpleName().toString() : name;
                result = "set" + Character.toUpperCase(result.charAt(0)) + result.substring(1);
            }
            return result;
        }

        @Override
        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.qualifiedType).add(this.param).toHashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AptParameter)) {
                return false;
            }
            AptParameter other = (AptParameter)obj;
            return org.jboss.logging.processor.util.Objects.areEqual(this.param, other.param) && org.jboss.logging.processor.util.Objects.areEqual(this.qualifiedType, other.qualifiedType);
        }

        @Override
        public int compareTo(Parameter other) {
            return Comparison.begin().compare((Comparable<?>)((Object)this.asType().toString()), (Comparable<?>)((Object)other.asType().toString())).compare((Comparable<?>)((Object)this.name()), (Comparable<?>)((Object)other.name())).result();
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add("name", this.name()).add("type", this.asType()).toString();
        }

        @Override
        public Element getDelegate() {
            return this.param;
        }
    }
}

