/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.cluster.ssh.launcher.SSHKeyInstaller;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_setup-ssh")
@I18n(value="setup.ssh")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
public class SetupSshCommand
implements AdminCommand {
    @Param(name="sshuser", optional=true, defaultValue="${user.name}")
    private String user;
    @Param(name="sshpassword", optional=false, password=true)
    private String sshpassword;
    @Param(name="sshkeypassphrase", optional=true, password=true)
    private String sshkeypassphrase;
    @Param(name="sshport", optional=true, defaultValue="22")
    private int port;
    @Param(optional=true)
    private String sshkeyfile;
    @Param(optional=true)
    private String sshpublickeyfile;
    @Param(optional=true, defaultValue="false")
    private boolean generatekey;
    @Param(optional=false, primary=true, multiple=true)
    private List<String> hosts;
    private Logger logger;
    private String realPass;
    TokenResolver resolver = new TokenResolver();

    private void validate() throws CommandException {
        File keyFile;
        this.user = this.resolver.resolve(this.user);
        if (!StringUtils.ok((String)this.sshpassword)) {
            throw new CommandException(Strings.get("setup.ssh.null.sshpass"));
        }
        this.realPass = SSHLauncher.expandPasswordAlias((String)this.sshpassword);
        if (this.realPass == null) {
            throw new CommandException(Strings.get("setup.ssh.unalias.error", this.sshpassword));
        }
        if (this.sshkeyfile == null) {
            File existingKey = SSHUtil.getExistingKeyFile();
            if (existingKey == null) {
                this.sshkeyfile = SSHUtil.getDefaultKeyFile().getAbsolutePath();
                if (!this.generatekey) {
                    throw new CommandException(Strings.get("setup.ssh.no.keyfile"));
                }
            } else {
                this.sshkeyfile = existingKey.getAbsolutePath();
                if (SSHUtil.isEncryptedKey((File)existingKey)) {
                    this.sshkeypassphrase = this.getSSHPassphrase();
                }
            }
        } else {
            keyFile = new File(this.sshkeyfile);
            if (!keyFile.isAbsolute()) {
                throw new CommandException(Strings.get("setup.ssh.invalid.path", keyFile));
            }
            SSHUtil.validateKeyFile((File)keyFile);
            if (SSHUtil.isEncryptedKey((File)keyFile)) {
                this.sshkeypassphrase = this.getSSHPassphrase();
            }
        }
        if (this.sshpublickeyfile != null) {
            keyFile = new File(this.sshpublickeyfile);
            if (!keyFile.isAbsolute()) {
                throw new CommandException(Strings.get("setup.ssh.invalid.path", keyFile));
            }
            SSHUtil.validateKeyFile((File)keyFile);
        }
    }

    public final void execute(AdminCommandContext context) {
        this.logger = context.getLogger();
        ActionReport report = context.getActionReport();
        try {
            this.validate();
        }
        catch (CommandException ce) {
            report.setMessage(ce.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        for (String node : this.hosts) {
            SSHLauncher sshL;
            block7: {
                File keyFile = this.sshkeyfile == null ? null : new File(this.sshkeyfile);
                sshL = new SSHLauncher(this.user, node, this.port, this.realPass, keyFile, this.sshkeypassphrase);
                if (this.generatekey && (this.sshkeyfile != null || SSHUtil.getExistingKeyFile() != null) && sshL.checkConnection()) {
                    this.logger.info(Strings.get("setup.ssh.already.configured", this.user, node));
                    continue;
                }
                try {
                    SSHKeyInstaller installer = new SSHKeyInstaller(sshL);
                    File pubKeyFile = this.sshpublickeyfile == null ? null : new File(this.sshpublickeyfile);
                    installer.setupKey(node, pubKeyFile, this.generatekey, this.realPass);
                }
                catch (IOException ce) {
                    this.logger.log(Level.INFO, "SSH key setup failed.", ce);
                    report.setMessage(Strings.get("setup.ssh.failed", ce.getMessage()));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                catch (Exception e) {
                    if (!this.logger.isLoggable(Level.FINER)) break block7;
                    this.logger.log(Level.FINER, "Keystore error: ", e);
                }
            }
            if (sshL.checkConnection()) continue;
            report.setMessage(Strings.get("setup.ssh.conn.failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    private String getSSHPassphrase() throws CommandException {
        String key = "";
        if (this.sshkeypassphrase != null && !this.sshkeypassphrase.isEmpty() && (key = SSHLauncher.expandPasswordAlias((String)this.sshkeypassphrase)) == null) {
            throw new CommandException("setup.ssh.null.keypassphrase");
        }
        return key;
    }
}

