/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.glassfish.jersey.microprofile.restclient.BeanParamModel;
import org.glassfish.jersey.microprofile.restclient.CookieParamModel;
import org.glassfish.jersey.microprofile.restclient.FormParamModel;
import org.glassfish.jersey.microprofile.restclient.HeaderParamModel;
import org.glassfish.jersey.microprofile.restclient.InterfaceModel;
import org.glassfish.jersey.microprofile.restclient.MatrixParamModel;
import org.glassfish.jersey.microprofile.restclient.PathParamModel;
import org.glassfish.jersey.microprofile.restclient.QueryParamModel;
import org.glassfish.jersey.model.Parameter;

abstract class ParamModel<T> {
    public static final Map<Class<? extends Annotation>, BiFunction<Builder, Annotation, ParamModel<?>>> PARAM_ANNOTATIONS = new HashMap();
    protected final InterfaceModel interfaceModel;
    protected final Parameter parameter;
    private final Type type;
    private final AnnotatedElement annotatedElement;
    private final int paramPosition;
    private final boolean entity;

    static ParamModel from(InterfaceModel interfaceModel, Type type, AnnotatedElement annotatedElement, Parameter parameter, int position) {
        return new Builder(interfaceModel, type, annotatedElement, parameter, position).build();
    }

    ParamModel(Builder builder) {
        this.interfaceModel = builder.interfaceModel;
        this.type = builder.type;
        this.annotatedElement = builder.annotatedElement;
        this.entity = builder.entity;
        this.paramPosition = builder.paramPosition;
        this.parameter = builder.parameter;
    }

    Type getType() {
        return this.type;
    }

    AnnotatedElement getAnnotatedElement() {
        return this.annotatedElement;
    }

    int getParamPosition() {
        return this.paramPosition;
    }

    boolean isEntity() {
        return this.entity;
    }

    abstract T handleParameter(T var1, Class<? extends Annotation> var2, Object var3);

    abstract boolean handles(Class<? extends Annotation> var1);

    static {
        PARAM_ANNOTATIONS.put(PathParam.class, (builder, annotation) -> new PathParamModel((Builder)builder, (PathParam)annotation));
        PARAM_ANNOTATIONS.put(HeaderParam.class, (builder, annotation) -> new HeaderParamModel((Builder)builder, (HeaderParam)annotation));
        PARAM_ANNOTATIONS.put(CookieParam.class, (builder, annotation) -> new CookieParamModel((Builder)builder, (CookieParam)annotation));
        PARAM_ANNOTATIONS.put(QueryParam.class, (builder, annotation) -> new QueryParamModel((Builder)builder, (QueryParam)annotation));
        PARAM_ANNOTATIONS.put(MatrixParam.class, (builder, annotation) -> new MatrixParamModel((Builder)builder, (MatrixParam)annotation));
        PARAM_ANNOTATIONS.put(FormParam.class, (builder, annotation) -> new FormParamModel((Builder)builder, (FormParam)annotation));
        PARAM_ANNOTATIONS.put(BeanParam.class, (builder, annotation) -> new BeanParamModel((Builder)builder));
    }

    protected static class Builder {
        private InterfaceModel interfaceModel;
        private Type type;
        private AnnotatedElement annotatedElement;
        private Parameter parameter;
        private boolean entity;
        private int paramPosition;

        private Builder(InterfaceModel interfaceModel, Type type, AnnotatedElement annotatedElement, Parameter parameter, int position) {
            this.interfaceModel = interfaceModel;
            this.type = type;
            this.annotatedElement = annotatedElement;
            this.parameter = parameter;
            this.paramPosition = position;
        }

        ParamModel build() {
            for (Class<? extends Annotation> paramAnnotation : PARAM_ANNOTATIONS.keySet()) {
                Annotation annot = this.annotatedElement.getAnnotation(paramAnnotation);
                if (annot == null) continue;
                return PARAM_ANNOTATIONS.get(paramAnnotation).apply(this, annot);
            }
            this.entity = true;
            return new ParamModel<Object>(this){

                @Override
                public Object handleParameter(Object requestPart, Class<? extends Annotation> annotationClass, Object instance) {
                    return requestPart;
                }

                @Override
                public boolean handles(Class<? extends Annotation> annotation) {
                    return false;
                }
            };
        }
    }
}

