/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.mapelresolver;

import com.sun.ts.tests.el.common.api.resolver.ResolverTest;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.MapELResolver;
import java.util.HashMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private HashMap<String, String> animals = new HashMap();

    public ELClientIT() {
        this.animals.put("dog", "retriever");
        this.animals.put("fish", "bass");
        this.animals.put("bird", "parrot");
    }

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void mapELResolverTest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        try {
            MapELResolver mapResolver = new MapELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            pass = ResolverTest.testELResolver(context, (ELResolver)mapResolver, this.animals, "dog", "labador", buf, false);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void mapELResolverNPETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        MapELResolver resolver = new MapELResolver();
        try {
            pass = ResolverTest.testELResolverNPE((ELResolver)resolver, this.animals, "dog", "billy", buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void mapELResolverPNWETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        MapELResolver resolver = new MapELResolver(true);
        BareBonesELContext barebonesComtext = new BareBonesELContext();
        ELContext context = barebonesComtext.getELContext();
        try {
            pass = ResolverTest.testELResolverPNWE(context, (ELResolver)resolver, this.animals, "dog", "billy", buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }
}

