/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.conditional;

import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Reception;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.conditional.AsyncConditionalEvent;
import org.jboss.cdi.tck.tests.event.observer.conditional.AsyncConditionalObserver;
import org.jboss.cdi.tck.tests.event.observer.conditional.ConditionalEvent;
import org.jboss.cdi.tck.tests.event.observer.conditional.RecluseSpider;
import org.jboss.cdi.tck.tests.event.observer.conditional.Tarantula;
import org.jboss.cdi.tck.tests.event.observer.conditional.TarantulaEvent;
import org.jboss.cdi.tck.tests.event.observer.conditional.Web;
import org.jboss.cdi.tck.tests.event.observer.conditional.WidowSpider;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class ConditionalObserverTest
extends AbstractTest {
    @Inject
    Event<AsyncConditionalEvent> asyncConditionalEventEvent;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ConditionalObserverTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observers_method_invocation", id="baa"), @SpecAssertion(section="conditional_observer_methods", id="a")})
    public void testConditionalObserver() {
        Event conditionalEvent = this.getCurrentManager().getEvent().select(ConditionalEvent.class, new Annotation[0]);
        conditionalEvent.fire((Object)new ConditionalEvent());
        assert (!WidowSpider.isNotified());
        WidowSpider bean = this.getContextualReference(WidowSpider.class, new Annotation[0]);
        assert (bean != null);
        assert (!bean.isInstanceNotified());
        conditionalEvent.fire((Object)new ConditionalEvent());
        assert (WidowSpider.isNotified() && bean.isInstanceNotified());
    }

    @Test
    @SpecAssertion(section="observers_method_invocation", id="baa")
    public void testObserverMethodInvokedOnReturnedInstanceFromContext() {
        RecluseSpider spider = this.getContextualReference(RecluseSpider.class, new Annotation[0]);
        spider.setWeb(new Web());
        this.getCurrentManager().getEvent().select(ConditionalEvent.class, new Annotation[0]).fire((Object)new ConditionalEvent());
        assert (spider.isInstanceNotified());
        assert (spider.getWeb().getRings() == 1);
    }

    @Test
    @SpecAssertion(section="conditional_observer_methods", id="c")
    public void testNotifyEnumerationContainsNotifyValues() {
        assert (Reception.values().length == 2);
        ArrayList<String> notifyValueNames = new ArrayList<String>();
        for (Reception value : Reception.values()) {
            notifyValueNames.add(value.name());
        }
        assert (notifyValueNames.contains("IF_EXISTS"));
        assert (notifyValueNames.contains("ALWAYS"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration"})
    @SpecAssertion(section="observer_notification", id="bca")
    public void testConditionalObserverMethodNotInvokedIfNoActiveContext() {
        Tarantula.reset();
        Context requestContext = this.getCurrentConfiguration().getContexts().getRequestContext();
        Tarantula tarantula = this.getContextualReference(Tarantula.class, new Annotation[0]);
        tarantula.ping();
        Event tarantulaEvent = this.getCurrentManager().getEvent().select(TarantulaEvent.class, new Annotation[0]);
        try {
            this.setContextInactive(requestContext);
            tarantulaEvent.fire((Object)new TarantulaEvent());
            Assert.assertFalse((boolean)Tarantula.isNotified());
        }
        finally {
            this.setContextActive(requestContext);
        }
        tarantulaEvent.fire((Object)new TarantulaEvent());
        Assert.assertTrue((boolean)Tarantula.isNotified());
    }

    @Test
    @SpecAssertion(section="conditional_observer_methods", id="a")
    public void testAsyncConditionalObserver() throws InterruptedException {
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        this.asyncConditionalEventEvent.fireAsync((Object)new AsyncConditionalEvent()).thenAccept(queue::offer);
        AsyncConditionalEvent event = (AsyncConditionalEvent)queue.poll(2L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)AsyncConditionalObserver.IsNotified().get());
        AsyncConditionalObserver observer = this.getContextualReference(AsyncConditionalObserver.class, new Annotation[0]);
        Assert.assertNotNull((Object)observer);
        observer.ping();
        this.asyncConditionalEventEvent.fireAsync((Object)new AsyncConditionalEvent()).thenAccept(queue::offer);
        event = (AsyncConditionalEvent)queue.poll(2L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)AsyncConditionalObserver.IsNotified().get());
    }
}

