/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.interceptors.definition.custom;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.cdi.tck.tests.full.interceptors.definition.custom.Secure;
import org.jboss.cdi.tck.tests.full.interceptors.definition.custom.SimpleInterceptorWithoutAnnotations;
import org.jboss.cdi.tck.tests.full.interceptors.definition.custom.Transactional;

public class CustomInterceptorImplementation
implements Interceptor<SimpleInterceptorWithoutAnnotations> {
    private Set<Annotation> interceptorBindingTypes = new HashSet<Annotation>();
    private InterceptionType type;
    private boolean getInterceptorBindingsCalled = false;
    private boolean interceptsCalled = false;

    public CustomInterceptorImplementation(InterceptionType type) {
        this.type = type;
        this.interceptorBindingTypes.add((Annotation)new AnnotationLiteral<Secure>(){});
        this.interceptorBindingTypes.add((Annotation)new AnnotationLiteral<Transactional>(){});
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public String getName() {
        return null;
    }

    public Set<Annotation> getQualifiers() {
        return Collections.emptySet();
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Set<Type> getTypes() {
        HashSet<Type> types = new HashSet<Type>();
        types.add((Type)((Object)Object.class));
        types.add(this.getBeanClass());
        return types;
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public Object intercept(InterceptionType type, SimpleInterceptorWithoutAnnotations instance, InvocationContext ctx) {
        try {
            return instance.intercept(ctx);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean intercepts(InterceptionType type) {
        this.interceptsCalled = true;
        return this.type.equals((Object)type);
    }

    public Set<Annotation> getInterceptorBindings() {
        this.getInterceptorBindingsCalled = true;
        return Collections.unmodifiableSet(this.interceptorBindingTypes);
    }

    public Class<?> getBeanClass() {
        return SimpleInterceptorWithoutAnnotations.class;
    }

    public SimpleInterceptorWithoutAnnotations create(CreationalContext<SimpleInterceptorWithoutAnnotations> creationalContext) {
        return new SimpleInterceptorWithoutAnnotations();
    }

    public void destroy(SimpleInterceptorWithoutAnnotations instance, CreationalContext<SimpleInterceptorWithoutAnnotations> creationalContext) {
        creationalContext.release();
    }

    public boolean isGetInterceptorBindingsCalled() {
        return this.getInterceptorBindingsCalled;
    }

    public boolean isInterceptsCalled() {
        return this.interceptsCalled;
    }
}

