/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.fires;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.cdi.tck.tests.event.fires.Item;
import org.jboss.cdi.tck.tests.event.fires.Lifted;
import org.jboss.cdi.tck.tests.event.fires.MiniBar;
import org.jboss.cdi.tck.tests.event.fires.Restored;

@RequestScoped
class Housekeeping {
    private Set<Item> itemsTainted = new HashSet<Item>();
    private Set<Item> itemsMissing = new HashSet<Item>();
    private List<Item> itemActivity = new ArrayList<Item>();

    Housekeeping() {
    }

    public void onItemRemoved(@Observes @Lifted Item item) {
        this.itemsMissing.add(item);
        this.itemsTainted.remove(item);
    }

    public void onItemRestored(@Observes @Restored Item item) {
        this.itemsMissing.remove(item);
        this.itemsTainted.add(item);
    }

    public void onItemActivity(@Observes @Any Item item) {
        this.itemActivity.add(item);
    }

    public Set<Item> getItemsTainted() {
        return this.itemsTainted;
    }

    public Set<Item> getItemsMissing() {
        return this.itemsMissing;
    }

    public List<Item> getItemActivity() {
        return this.itemActivity;
    }

    public void minibarStocked(@Observes @Any MiniBar minibar) {
        this.reset();
    }

    public void reset() {
        this.itemActivity.clear();
        this.itemsMissing.clear();
        this.itemsTainted.clear();
    }
}

