/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration.ui;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edapt.common.ui.ResizeableDialogBase;
import org.eclipse.emf.edapt.common.ui.SelectionUtils;
import org.eclipse.emf.edapt.common.ui.StructureTreeViewer;
import org.eclipse.emf.edapt.migration.ui.MigrationModelSash;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Model;
import org.eclipse.emf.edapt.spi.migration.Repository;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class ChoiceDialog
extends ResizeableDialogBase {
    private final List<?> choices;
    private final Instance instance;
    private StructureTreeViewer modelViewer;
    private TableViewer choiceViewer;
    private Object selectedElement;
    private ComposedAdapterFactory adapterFactory;

    public ChoiceDialog(Instance instance, List<?> choices, String message) {
        super(new Point(800, 600), "Choice", message);
        this.instance = instance;
        this.choices = choices;
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory();
        adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = adapterFactory;
        SashForm sash = new SashForm(parent, 256);
        sash.setLayoutData((Object)new GridData(1808));
        this.createModelViewer(sash);
        this.createChoiceViewer(sash);
        sash.setWeights(new int[]{1, 1});
        return parent;
    }

    private void createModelViewer(SashForm sash) {
        MigrationModelSash modelSash = new MigrationModelSash((Composite)sash, 0, (AdapterFactory)this.adapterFactory);
        this.modelViewer = modelSash.getStructureViewer();
        Repository repository = this.instance.getType().getModel().getRepository();
        this.modelViewer.setInput((Object)repository);
        this.modelViewer.setSelection((ISelection)new StructuredSelection((Object)this.instance), true);
        this.createContextMenu();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object element;
                IStructuredSelection selection = (IStructuredSelection)ChoiceDialog.this.modelViewer.getSelection();
                if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof Instance) {
                    final Instance instance = (Instance)element;
                    IEditingDomainItemProvider provider = (IEditingDomainItemProvider)ChoiceDialog.this.adapterFactory.adapt((Object)instance, IEditingDomainItemProvider.class);
                    Collection descriptors = provider.getNewChildDescriptors((Object)instance, null, null);
                    for (Object descriptor : descriptors) {
                        if (!(descriptor instanceof CommandParameter)) continue;
                        CommandParameter parameter = (CommandParameter)descriptor;
                        final EReference reference = parameter.getEReference();
                        final EClass type = parameter.getEValue().eClass();
                        manager.add((IAction)new Action("Create " + reference.getName() + ":" + type.getName()){

                            public void run() {
                                Model model = instance.getType().getModel();
                                Instance child = model.newInstance(type);
                                instance.add((EStructuralFeature)reference, (Object)child);
                                ChoiceDialog.this.modelViewer.refresh((Object)instance);
                            }
                        });
                    }
                }
            }
        });
        Menu menu = menuManager.createContextMenu(this.modelViewer.getControl());
        this.modelViewer.getControl().setMenu(menu);
    }

    private void createChoiceViewer(SashForm sash) {
        this.choiceViewer = new TableViewer((Composite)sash, 2048);
        this.choiceViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ChoiceDialog.this.choices.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
        this.choiceViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.choiceViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element = SelectionUtils.getSelectedElement((ISelection)event.getSelection(), Object.class);
                ChoiceDialog.this.modelViewer.setSelection((ISelection)new StructuredSelection(element));
            }
        });
        this.choiceViewer.setInput(this.choices);
        this.choiceViewer.setSelection((ISelection)new StructuredSelection(this.choiceViewer.getElementAt(0)));
    }

    protected void okPressed() {
        this.selectedElement = SelectionUtils.getSelectedElement((ISelection)this.choiceViewer.getSelection(), Object.class);
        super.okPressed();
    }

    public Object getSelectedElement() {
        return this.selectedElement;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    public boolean close() {
        this.adapterFactory.dispose();
        return super.close();
    }
}

