/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.spi.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecp.ide.spi.util.EcoreHelper;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;

public final class ViewModelHelper {
    private ViewModelHelper() {
    }

    public static VView createViewModel(IFile modelFile, EClass selectedEClass, IFile selectedEcore) throws IOException {
        EPackage ep;
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{adapterFactory, new ReflectiveItemProviderAdapterFactory()});
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)new BasicCommandStack());
        URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
        Resource resource = domain.createResource(fileURI.toString());
        VView view = VViewPackage.eINSTANCE.getViewFactory().createView();
        if (view == null) {
            return null;
        }
        resource.getContents().add((Object)view);
        EPackage ePackage = selectedEClass.getEPackage();
        EPackage.Registry instance = EPackage.Registry.INSTANCE;
        Object ePackageObject = instance.get((Object)ePackage.getNsURI());
        if (EPackage.Descriptor.class.isInstance(ePackageObject)) {
            EPackage.Descriptor descriptor = (EPackage.Descriptor)EPackage.Descriptor.class.cast(ePackageObject);
            ep = descriptor.getEPackage();
        } else {
            ep = EPackage.class.isInstance(ePackageObject) ? (EPackage)ePackageObject : null;
        }
        if (ep == null && selectedEcore != null) {
            EcoreHelper.registerEcore(selectedEcore.getFullPath().toString());
            ep = (EPackage)instance.get((Object)ePackage.getNsURI());
        }
        EClass ec = (EClass)ep.getEClassifier(selectedEClass.getName());
        view.setRootEClass(ec);
        view.setName(selectedEClass.getName());
        if (selectedEcore != null && !view.getEcorePaths().contains((Object)selectedEcore.getFullPath().toString())) {
            view.getEcorePaths().add((Object)selectedEcore.getFullPath().toString());
        }
        HashMap options = new HashMap();
        resource.save(options);
        return view;
    }

    public static VView loadView(IFile file, Collection<String> registeredEcores) throws IOException {
        String path = file.getLocation().toString();
        VView view = ViewModelHelper.loadView(path);
        ViewModelHelper.registerReferencedEcores(view, registeredEcores);
        if (view != null && !ViewModelHelper.viewIsResolved(view)) {
            EcoreUtil.resolveAll((EObject)view);
        }
        return view;
    }

    private static void registerReferencedEcores(VView view, Collection<String> registeredEcores) throws IOException {
        if (view == null || view.getEcorePaths() == null) {
            return;
        }
        for (String ecorePath : view.getEcorePaths()) {
            if (ResourcesPlugin.getWorkspace().getRoot().findMember(ecorePath) == null) {
                throw new FileNotFoundException(ecorePath);
            }
            EcoreHelper.registerEcore(ecorePath);
            registeredEcores.add(ecorePath);
        }
    }

    public static boolean viewIsResolved(VView view) {
        return !view.getRootEClass().eIsProxy();
    }

    private static VView loadView(String path) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createFileURI((String)path);
        Resource resource = resourceSet.getResource(fileURI, true);
        if (resource != null) {
            return (VView)resource.getContents().get(0);
        }
        return null;
    }

    public static List<String> getEcorePaths(Resource resource) {
        if (resource == null || resource.getContents().isEmpty()) {
            return Collections.emptyList();
        }
        EObject eObject = (EObject)resource.getContents().get(0);
        if (VView.class.isInstance(eObject)) {
            return ((VView)VView.class.cast(eObject)).getEcorePaths();
        }
        if (AnyType.class.isInstance(eObject)) {
            FeatureMap anyAttribute = ((AnyType)AnyType.class.cast(eObject)).getAnyAttribute();
            int i = 0;
            while (i < anyAttribute.size()) {
                EStructuralFeature feature = anyAttribute.getEStructuralFeature(i);
                if ("ecorePath".equals(feature.getName())) {
                    return Arrays.asList((String)anyAttribute.getValue(i));
                }
                if ("ecorePaths".equals(feature.getName())) {
                    return (List)anyAttribute.getValue(i);
                }
                ++i;
            }
        }
        return Collections.emptyList();
    }
}

