/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.handler;

import java.text.MessageFormat;
import java.util.Optional;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.ui.view.swt.reference.OpenInNewContextStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.ReferenceServiceCustomizationVendor;
import org.eclipse.emf.ecp.view.internal.editor.handler.CreateSegmentDmrWizard;
import org.eclipse.emf.ecp.view.spi.editor.controls.EStructuralFeatureSelectionValidator;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.rule.RuleConditionDmrUtil;
import org.eclipse.emf.ecp.view.spi.rule.model.Condition;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.bazaar.Create;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.ide.view.segments.ToolingModeUtil;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="RuleConditionDmrOpenInNewContextStrategyProvider", property={"service.ranking:Integer=30"})
public class RuleConditionDmrOpenInNewContextStrategyProvider
extends ReferenceServiceCustomizationVendor<OpenInNewContextStrategy>
implements OpenInNewContextStrategy.Provider {
    private EMFFormsDatabindingEMF databinding;
    private ReportService reportService;

    @Reference(unbind="-")
    void setEMFFormsDatabindingEMF(EMFFormsDatabindingEMF databinding) {
        this.databinding = databinding;
    }

    @Reference(unbind="-")
    void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    protected boolean handles(EObject owner, EReference reference) {
        return this.isSegmentToolingEnabled() && owner instanceof Condition && reference.getEReferenceType() == VViewPackage.Literals.DOMAIN_MODEL_REFERENCE;
    }

    protected boolean isSegmentToolingEnabled() {
        return ToolingModeUtil.isSegmentToolingEnabled();
    }

    protected EStructuralFeatureSelectionValidator getSelectionValidator() {
        return feature -> null;
    }

    @Create
    public OpenInNewContextStrategy createOpenInNewContextStrategy() {
        return new Strategy();
    }

    class Strategy
    implements OpenInNewContextStrategy {
        Strategy() {
        }

        public boolean openInNewContext(EObject owner, EReference reference, EObject object) {
            Optional rootEClass = RuleConditionDmrUtil.getDmrRootEClass((EMFFormsDatabindingEMF)RuleConditionDmrOpenInNewContextStrategyProvider.this.databinding, (ReportService)RuleConditionDmrOpenInNewContextStrategyProvider.this.reportService, (EObject)owner);
            if (!rootEClass.isPresent()) {
                String message = MessageFormat.format("Could not edit the domain model reference for condition ''{0}'' because no root EClass could be determined.", owner);
                RuleConditionDmrOpenInNewContextStrategyProvider.this.reportService.report(new AbstractReport(message, 2));
                return false;
            }
            CreateSegmentDmrWizard dmrWizard = new CreateSegmentDmrWizard((EClass)rootEClass.get(), "Edit Domain Model Reference", (VDomainModelReference)object, RuleConditionDmrOpenInNewContextStrategyProvider.this.getSelectionValidator());
            WizardDialog wizardDialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)dmrWizard);
            wizardDialog.setBlockOnOpen(true);
            wizardDialog.open();
            Optional<VDomainModelReference> dmr = dmrWizard.getDomainModelReference();
            if (dmr.isPresent()) {
                EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)owner);
                Command command = SetCommand.create((EditingDomain)domain, (Object)owner, (Object)reference, (Object)dmr.get());
                domain.getCommandStack().execute(command);
            }
            return true;
        }
    }
}

