/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.table.swt;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.emf.ecp.view.internal.table.swt.Activator;
import org.eclipse.swt.widgets.Display;

public class RunnableManager {
    private final Lock lock = new ReentrantLock();
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final Condition runningCond = this.lock.newCondition();
    private final AtomicReference<Runnable> pending = new AtomicReference();
    private final Display display;

    public RunnableManager(Display display) {
        this.display = display;
    }

    private void finish(Runnable runnable) {
        this.lock.lock();
        try {
            this.isRunning.compareAndSet(true, false);
            this.runningCond.signalAll();
            Runnable next = this.pending.getAndSet(null);
            if (next != null) {
                this.executeAsync(next);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private Runnable createWrapperRunnable(final Runnable runnable) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    RunnableManager.this.finish(runnable);
                }
            }
        };
    }

    public void executeAsync(Runnable runnable) {
        this.lock.lock();
        try {
            if (this.isRunning.compareAndSet(false, true)) {
                this.doExecuteAsync(runnable);
                this.runningCond.signalAll();
            } else {
                this.pending.compareAndSet(null, runnable);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doExecuteAsync(Runnable runnable) {
        if (runnable instanceof BackgroundStage) {
            this.runStage(runnable, (BackgroundStage)((Object)runnable));
        } else {
            this.getDisplay().asyncExec(this.createWrapperRunnable(runnable));
        }
    }

    public synchronized Display getDisplay() {
        return this.display;
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    /*
     * Exception decompiling
     */
    public final void waitForIdle() throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final boolean waitForIdle(long time, TimeUnit unit) throws InterruptedException {
        if (time <= 0L) {
            this.waitForIdle();
            return true;
        }
        long deadline = System.nanoTime() + unit.toNanos(time);
        if (!this.isRunning()) {
            return true;
        }
        boolean busyWait = Display.getCurrent() == this.display;
        this.lock.lock();
        try {
            while (this.isRunning()) {
                long remaining = deadline - System.nanoTime();
                if (remaining <= 0L) {
                    return false;
                }
                if (busyWait) {
                    block14: {
                        try {
                            this.lock.unlock();
                            while (this.isRunning()) {
                                if (this.display.readAndDispatch()) continue;
                                break block14;
                            }
                            break;
                        }
                        finally {
                            this.lock.lock();
                        }
                    }
                    this.runningCond.await(50L, TimeUnit.MILLISECONDS);
                    continue;
                }
                this.runningCond.awaitNanos(remaining);
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    private void runStage(Runnable computation, BackgroundStage stage) {
        CompletableFuture.runAsync(computation).whenComplete((result, exception) -> {
            if (exception != null) {
                this.finish(computation);
                Activator.getInstance().log((Throwable)exception);
            } else {
                Runnable next = stage.getNextStage();
                if (next == null) {
                    this.finish(computation);
                } else {
                    this.doExecuteAsync(next);
                }
            }
        });
    }

    public static interface BackgroundStage {
        public Runnable getNextStage();
    }
}

