/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.actions;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.DTreeItemContainer;
import org.eclipse.sirius.tree.business.api.command.ITreeCommandFactory;
import org.eclipse.sirius.tree.business.internal.helper.TreeHelper;
import org.eclipse.sirius.tree.description.TreeItemCreationTool;
import org.eclipse.sirius.tree.description.TreeItemMapping;
import org.eclipse.sirius.tree.description.TreeItemTool;
import org.eclipse.sirius.tree.ui.provider.TreeUIPlugin;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeViewerManager;
import org.eclipse.sirius.tree.ui.tools.internal.editor.actions.AbstractToolItemAction;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.CreateInstance;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class CreateToolItemAction
extends AbstractToolItemAction {
    private DTree tree;

    public CreateToolItemAction(TreeItemCreationTool createTool, TransactionalEditingDomain editingDomain, ITreeCommandFactory tableCommandFactory) {
        super(MessageTranslator.INSTANCE.getMessage((EObject)createTool, new IdentifiedElementQuery((IdentifiedElement)createTool).getLabel()), CreateToolItemAction.findImageDescriptor(createTool), editingDomain, tableCommandFactory, (TreeItemTool)createTool);
    }

    private static ImageDescriptor findImageDescriptor(TreeItemCreationTool createTool) {
        ImageDescriptor semanticDescriptor;
        IItemLabelProvider labelProvider;
        ImageDescriptor descriptor = DTreeViewerManager.getImageRegistry().getDescriptor("tree/newTreeItem");
        EObject created = null;
        UnmodifiableIterator createInstances = Iterators.filter((Iterator)createTool.eAllContents(), CreateInstance.class);
        while (created == null && createInstances.hasNext()) {
            CreateInstance map = (CreateInstance)createInstances.next();
            created = CreateToolItemAction.tryToInstanciateType(createTool, created, map.getTypeName());
        }
        Iterator it = createTool.getMapping().iterator();
        while (created == null && it.hasNext()) {
            TreeItemMapping map = (TreeItemMapping)it.next();
            created = CreateToolItemAction.tryToInstanciateType(createTool, created, map.getDomainClass());
        }
        if (created != null && (labelProvider = (IItemLabelProvider)TreeUIPlugin.getPlugin().getItemProvidersAdapterFactory().adapt((Notifier)created, IItemLabelProvider.class)) != null && (semanticDescriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage((Object)created))) != null) {
            descriptor = semanticDescriptor;
        }
        return descriptor;
    }

    private static EObject tryToInstanciateType(TreeItemCreationTool createTool, EObject created, String map) {
        EObject result = created;
        if (!StringUtil.isEmpty((String)map)) {
            try {
                EObject anInstance;
                result = anInstance = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)createTool).createInstance(map);
            }
            catch (MetaClassNotFoundException metaClassNotFoundException) {}
        }
        return result;
    }

    public void run() {
        DTreeItemContainer lineContainer;
        EObject target;
        super.run();
        DTreeItem dTreeItem = this.getTreeItem();
        if (dTreeItem != null) {
            target = dTreeItem.getTarget();
            lineContainer = (DTreeItemContainer)dTreeItem.eContainer();
        } else {
            target = this.tree.getTarget();
            lineContainer = this.tree;
        }
        Command cmd = this.treeCommandFactory.buildCreateLineCommandFromTool(lineContainer, target, this.getCreationTool());
        String label = this.getText();
        cmd = new CommandWrapper(label, label, cmd);
        this.getEditingDomain().getCommandStack().execute(cmd);
    }

    private TreeItemCreationTool getCreationTool() {
        TreeItemCreationTool tool = null;
        TreeItemTool tableTool = this.getTool();
        if (tableTool instanceof TreeItemCreationTool) {
            tool = (TreeItemCreationTool)tableTool;
        }
        return tool;
    }

    @Override
    public boolean canExecute() {
        boolean canExecute = true;
        if (this.getCreationTool() != null) {
            if (this.getCreationTool().getFirstModelOperation() == null) {
                canExecute = false;
            } else if (this.getCreationTool().getPrecondition() != null && !StringUtil.isEmpty((String)this.getCreationTool().getPrecondition().trim())) {
                IInterpreter interpreter = null;
                try {
                    if (this.getTreeItem() != null) {
                        interpreter = InterpreterUtil.getInterpreter((EObject)this.getTreeItem().getTarget());
                        interpreter.setVariable("root", (Object)TreeHelper.getTree((EObject)this.getTreeItem()).getTarget());
                        interpreter.setVariable("element", (Object)this.getTreeItem().getTarget());
                        interpreter.setVariable("container", (Object)((DTreeItemContainer)this.getTreeItem().eContainer()).getTarget());
                        canExecute = interpreter.evaluateBoolean(this.getTreeItem().getTarget(), this.getCreationTool().getPrecondition());
                    } else {
                        interpreter = InterpreterUtil.getInterpreter((EObject)this.getTable().getTarget());
                        interpreter.setVariable("root", (Object)this.getTable().getTarget());
                        interpreter.setVariable("element", (Object)this.getTable().getTarget());
                        interpreter.setVariable("container", null);
                        canExecute = interpreter.evaluateBoolean(this.getTable().getTarget(), this.getCreationTool().getPrecondition());
                    }
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)this.getCreationTool(), (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
                }
                interpreter.unSetVariable("root");
                interpreter.unSetVariable("element");
                interpreter.unSetVariable("container");
            }
        }
        return canExecute;
    }

    public DTree getTable() {
        return this.tree;
    }

    public void setTable(DTree table) {
        this.tree = table;
    }
}

