/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.tools.internal.menu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.editor.properties.internal.Messages;
import org.eclipse.sirius.editor.properties.tools.internal.menu.PropertiesCreateChildAction;
import org.eclipse.sirius.editor.tools.api.menu.AbstractMenuBuilder;
import org.eclipse.sirius.editor.tools.api.menu.AbstractTypeRestrictingMenuBuilder;
import org.eclipse.sirius.properties.Category;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.PropertiesFactory;
import org.eclipse.sirius.properties.PropertiesPackage;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.properties.defaultrules.api.DefaultRulesProvider;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.ui.IEditorPart;

public class PropertiesMenuBuilder
extends AbstractTypeRestrictingMenuBuilder {
    public PropertiesMenuBuilder() {
        this.addValidType((EClassifier)PropertiesPackage.Literals.VIEW_EXTENSION_DESCRIPTION);
    }

    public String getLabel() {
        return Messages.PropertiesMenuBuilder_label;
    }

    public int getPriority() {
        return AbstractMenuBuilder.EXTENSION;
    }

    public void update(Collection<?> newChildDescriptors, ISelection selection, IEditorPart editor) {
        this.depopulate();
        this.advancedChildActions = new ArrayList();
        Optional<CommandParameter> optionalNewPropertyViewCommandParameter = newChildDescriptors.stream().filter(CommandParameter.class::isInstance).map(CommandParameter.class::cast).filter(parameter -> DescriptionPackage.Literals.GROUP__EXTENSIONS.equals(parameter.getEStructuralFeature())).findFirst();
        if (selection instanceof IStructuredSelection && optionalNewPropertyViewCommandParameter.isPresent()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            CommandParameter newPropertyViewCommandParameter = optionalNewPropertyViewCommandParameter.get();
            this.descriptors.add(newPropertyViewCommandParameter);
            Optional<Group> optionalGroup = Arrays.stream(structuredSelection.toArray()).filter(Group.class::isInstance).map(Group.class::cast).findFirst();
            optionalGroup.ifPresent(group -> {
                newPropertyViewCommandParameter.setOwner(group);
                CommandParameter importPropertyViewCommandParameter = this.getImportPropertyViewCommandParameter((Group)group);
                CommandParameter extendsPropertyViewCommandParameter = this.getExtendsPropertyViewCommandParameter((Group)group);
                ArrayList<PropertiesCreateChildAction> actions = new ArrayList<PropertiesCreateChildAction>();
                actions.add(new PropertiesCreateChildAction(editor, (ISelection)structuredSelection, newPropertyViewCommandParameter, Messages.PropertiesMenuBuilder_NewPropertiesView_label, 1000));
                actions.add(new PropertiesCreateChildAction(editor, (ISelection)structuredSelection, importPropertyViewCommandParameter, Messages.PropertiesMenuBuilder_ImportPropertiesView_label, 2000));
                actions.add(new ExtendsPropertyViewCreateChildAction(editor, (ISelection)structuredSelection, extendsPropertyViewCommandParameter));
                this.advancedChildActions = actions;
            });
        }
    }

    private CommandParameter getImportPropertyViewCommandParameter(Group group) {
        ViewExtensionDescription viewExtensionDescription = DefaultRulesProvider.INSTANCE.getDefaultRules();
        return new CommandParameter((Object)group, (Object)DescriptionPackage.Literals.GROUP__EXTENSIONS, (Object)EcoreUtil.copy((EObject)viewExtensionDescription));
    }

    private CommandParameter getExtendsPropertyViewCommandParameter(Group group) {
        ViewExtensionDescription viewExtensionDescription = PropertiesFactory.eINSTANCE.createViewExtensionDescription();
        PageDescription pageDescription = PropertiesFactory.eINSTANCE.createPageDescription();
        Category category = PropertiesFactory.eINSTANCE.createCategory();
        category.getPages().add((Object)pageDescription);
        viewExtensionDescription.getCategories().add((Object)category);
        return new CommandParameter((Object)group, (Object)DescriptionPackage.Literals.GROUP__EXTENSIONS, (Object)viewExtensionDescription);
    }

    protected int getPriority(IAction action) {
        if (action instanceof PropertiesCreateChildAction) {
            return ((PropertiesCreateChildAction)action).getPriority();
        }
        return super.getPriority(action);
    }

    private static class ExtendsPropertyViewCreateChildAction
    extends PropertiesCreateChildAction {
        ExtendsPropertyViewCreateChildAction(IEditorPart editorPart, ISelection selection, CommandParameter commandParameter) {
            super(editorPart, selection, commandParameter, Messages.PropertiesMenuBuilder_ExtendPropertiesView_label, 3000);
        }

        public void run() {
            if (this.descriptor instanceof CommandParameter) {
                CommandParameter commandParameter = (CommandParameter)this.descriptor;
                Object owner = commandParameter.getOwner();
                Object value = commandParameter.getValue();
                if (owner instanceof Group && value instanceof ViewExtensionDescription) {
                    Group group = (Group)owner;
                    ViewExtensionDescription viewExtensionDescription = (ViewExtensionDescription)value;
                    viewExtensionDescription.getCategories().stream().findFirst().ifPresent(category -> category.getPages().stream().findFirst().ifPresent(pageDescription -> {
                        ViewExtensionDescription defaultRules = DefaultRulesProvider.INSTANCE.getDefaultRules(group.eResource().getResourceSet());
                        Optional pageDescriptionToExtend = defaultRules.getCategories().stream().findFirst().flatMap(defaultCategory -> defaultCategory.getPages().stream().findFirst());
                        pageDescriptionToExtend.ifPresent(arg_0 -> ((PageDescription)pageDescription).setExtends(arg_0));
                    }));
                }
            }
            super.run();
        }
    }
}

