/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.filters.internal.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.filters.internal.FilterPlugin;
import org.eclipse.emf.ecoretools.filters.internal.Messages;
import org.eclipse.emf.ecoretools.filters.internal.commands.ShowHiddenPartsCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class ShowHiddenPartAction
extends Action {
    protected IGraphicalEditPart host;
    public static String ID = "showHiddenPartAction";

    public ShowHiddenPartAction() {
        this.setId(ID);
        this.setText(Messages.ShowHiddenPartAction_ShowAllHiddenParts);
        this.setToolTipText(Messages.ShowHiddenPartAction_ShowAllHiddenParts_tooltip);
        this.setImageDescriptor(FilterPlugin.getImageDescriptor("icons/etool16/showhiddentpart_exec.gif"));
    }

    private Diagram getCurrentDiagram() {
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (!(editorPart instanceof DiagramEditor)) {
            return null;
        }
        this.host = ((DiagramEditor)editorPart).getDiagramEditPart();
        if (!(this.host instanceof IGraphicalEditPart)) {
            return null;
        }
        View view = (View)this.host.getModel();
        Diagram diagram = view.getDiagram();
        return diagram;
    }

    public void run() {
        Diagram diagram = this.getCurrentDiagram();
        if (diagram == null) {
            return;
        }
        ICommandProxy cmd = new ICommandProxy((ICommand)new ShowHiddenPartsCommand(this.host.getEditingDomain(), diagram));
        DiagramCommandStack commandStack = this.host.getDiagramEditDomain().getDiagramCommandStack();
        commandStack.execute((Command)cmd, (IProgressMonitor)new NullProgressMonitor());
    }

    public boolean isEnabled() {
        if (this.getCurrentDiagram() == null) {
            return false;
        }
        TreeIterator it = this.getCurrentDiagram().eAllContents();
        while (it.hasNext()) {
            EObject currentDiagramElement = (EObject)it.next();
            if (!(currentDiagramElement instanceof View) || ((View)currentDiagramElement).isVisible()) continue;
            return true;
        }
        return false;
    }
}

