/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.help.hovers;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.ui.completion.IHelpResolver;
import org.eclipse.ease.ui.help.hovers.internal.VirtualProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.ResolvedBinaryType;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocBrowserInformationControlInput;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocHover;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.objectweb.asm.Type;

public class JavaClassHelpResolver
implements IHelpResolver {
    private static IJavaProject JAVA_PROJECT;
    private final String fPackageName;
    private final String fClassName;
    private Class<?> fClazz;

    public static IJavaProject getJavaProject() {
        if (JAVA_PROJECT == null) {
            VirtualProject project = new VirtualProject();
            JAVA_PROJECT = JavaCore.create((IProject)project);
        }
        return JAVA_PROJECT;
    }

    public JavaClassHelpResolver(String packageName, String className) {
        this.fPackageName = packageName.replace('.', '/');
        this.fClassName = className;
        if (className != null) {
            try {
                this.fClazz = JavaClassHelpResolver.class.getClassLoader().loadClass(String.valueOf(packageName) + "." + className.replace('.', '$'));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.fClazz = null;
            }
        } else {
            this.fClazz = null;
        }
    }

    protected JavaClassHelpResolver() {
        this.fPackageName = null;
        this.fClassName = null;
        this.fClazz = null;
    }

    @Override
    public String resolveHelp() {
        ITypeRoot typeRoot = this.resolveTypeRoot(JavaClassHelpResolver.getJavaProject());
        IJavaElement javaElement = this.resolveJavaElement(typeRoot);
        JavadocBrowserInformationControlInput hoverInfo = JavadocHover.getHoverInfo((IJavaElement[])new IJavaElement[]{javaElement}, (ITypeRoot)typeRoot, (IRegion)new Region(0, 1), null);
        if (hoverInfo != null) {
            return hoverInfo.getHtml();
        }
        return null;
    }

    @Override
    public String resolveHTMLHelp() {
        return this.resolveHelp();
    }

    protected ITypeRoot resolveTypeRoot(IJavaProject javaProject) {
        Path elementPath = new Path(this.fPackageName);
        elementPath = elementPath.append(String.valueOf(this.fClassName.replace('.', '$')) + ".java");
        try {
            IJavaElement root = javaProject.findElement((IPath)elementPath);
            if (root instanceof ITypeRoot) {
                return (ITypeRoot)root;
            }
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    protected IJavaElement resolveJavaElement(ITypeRoot javaElement) {
        if (javaElement instanceof JavaElement) {
            return new ResolvedBinaryType((JavaElement)javaElement, this.fClazz.getSimpleName(), JavaClassHelpResolver.getDescriptor(this.fClazz));
        }
        return null;
    }

    protected String getPackageName() {
        return this.fPackageName;
    }

    protected static String getDescriptor(Class<?> clazz) {
        return Type.getDescriptor(clazz).replace('/', '.');
    }
}

