/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion.provider;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.ui.completion.AbstractCompletionProvider;
import org.eclipse.ease.ui.completion.provider.JavaMethodCompletionProvider;
import org.eclipse.ease.ui.modules.ui.ModulesTools;
import org.eclipse.jface.viewers.StyledString;

public class LoadedModuleCompletionProvider
extends AbstractCompletionProvider {
    @Override
    public boolean isActive(ICompletionContext context) {
        return context.getType() == ICompletionContext.Type.NONE;
    }

    @Override
    protected void prepareProposals(ICompletionContext context) {
        for (ModuleDefinition definition : context.getLoadedModules()) {
            StyledString styledString;
            for (Field field : definition.getFields()) {
                if (!this.matchesFilterIgnoreCase(field.getName())) continue;
                styledString = new StyledString(field.getName());
                styledString.append(" : " + field.getType().getSimpleName(), StyledString.DECORATIONS_STYLER);
                styledString.append(" - " + definition.getName(), StyledString.QUALIFIER_STYLER);
                this.addProposal(styledString, field.getName(), JavaMethodCompletionProvider.getSharedImage("org.eclipse.jdt.ui.field_public_obj.gif"), 20, null);
            }
            for (Method method : definition.getMethods()) {
                if (!this.matchesFilterIgnoreCase(method.getName())) continue;
                styledString = ModulesTools.getSignature(method, true);
                styledString.append(" - " + definition.getName(), StyledString.QUALIFIER_STYLER);
                if (method.getParameterTypes().length - ModulesTools.getOptionalParameterCount(method) > 0) {
                    this.addProposal(styledString, String.valueOf(method.getName()) + "(", JavaMethodCompletionProvider.getSharedImage("org.eclipse.jdt.ui.field_public_obj.gif"), 40, null);
                    continue;
                }
                this.addProposal(styledString, String.valueOf(method.getName()) + "()", JavaMethodCompletionProvider.getSharedImage("org.eclipse.jdt.ui.field_public_obj.gif"), 40, null);
            }
        }
    }
}

