/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.rhino;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptExecutionException;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptDebugFrame;
import org.eclipse.ease.lang.javascript.JavaScriptHelper;
import org.eclipse.ease.lang.javascript.rhino.ObservingContextFactory;
import org.eclipse.ease.lang.javascript.rhino.RhinoClassLoader;
import org.eclipse.ease.tools.RunnableWithResult;
import org.eclipse.swt.widgets.Display;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.debug.Debugger;

public class RhinoScriptEngine
extends AbstractScriptEngine {
    public static final String ENGINE_ID = "org.eclipse.ease.javascript.rhino";
    private ScriptableObject mScope;
    private Context mContext;
    private Debugger mDebugger = null;
    private int mOptimizationLevel = 9;

    static {
        ContextFactory.initGlobal((ContextFactory)new ObservingContextFactory());
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ContextFactory.getGlobal().initApplicationClassLoader((ClassLoader)RhinoClassLoader.getInstance());
                return null;
            }
        });
    }

    public RhinoScriptEngine() {
        super("Rhino");
    }

    protected RhinoScriptEngine(String name) {
        super(name);
    }

    public void setOptimizationLevel(int level) {
        this.mOptimizationLevel = level;
    }

    protected synchronized boolean setupEngine() {
        this.mContext = this.getContext();
        if (this.mDebugger != null) {
            this.mContext.setOptimizationLevel(-1);
            this.mContext.setGeneratingDebug(true);
            this.mContext.setGeneratingSource(true);
            this.mContext.setDebugger(this.mDebugger, null);
        } else {
            this.mContext.setGeneratingDebug(false);
            this.mContext.setOptimizationLevel(this.mOptimizationLevel);
            this.mContext.setDebugger(null, null);
        }
        this.mScope = new ImporterTopLevel(this.mContext);
        this.mContext.setGenerateObserverCount(true);
        this.mContext.setInstructionObserverThreshold(10);
        return true;
    }

    protected synchronized boolean teardownEngine() {
        this.mContext.setDebugger(null, null);
        Context.exit();
        this.mContext = null;
        this.mScope = null;
        RhinoClassLoader.unregisterEngine(this);
        return true;
    }

    protected Object execute(final Script script, final Object reference, final String fileName, boolean uiThread) throws Throwable {
        if (uiThread) {
            RunnableWithResult<Object> runnable = new RunnableWithResult<Object>(){

                public void runWithTry() throws Throwable {
                    RhinoScriptEngine.this.getContext().initStandardObjects(RhinoScriptEngine.this.mScope);
                    this.setResult(RhinoScriptEngine.this.internalExecute(script, reference, fileName));
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return runnable.getResultFromTry();
        }
        return this.internalExecute(script, reference, fileName);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object internalExecute(Script script, Object reference, String fileName) throws Throwable {
        Object result;
        InputStreamReader codeReader;
        block27: {
            block26: {
                block25: {
                    ((ObservingContextFactory)ContextFactory.getGlobal()).cancelTerminate(this.getContext());
                    codeReader = new InputStreamReader(script.getCodeStream());
                    result = script.getCommand() instanceof NativeFunction ? ((NativeFunction)script.getCommand()).call(this.getContext(), (Scriptable)this.mScope, (Scriptable)this.mScope, ScriptRuntime.emptyArgs) : (script.getCommand() instanceof org.mozilla.javascript.Script ? ((org.mozilla.javascript.Script)script.getCommand()).exec(this.getContext(), (Scriptable)this.mScope) : this.getContext().evaluateReader((Scriptable)this.mScope, (Reader)codeReader, fileName, 1, null));
                    if (result != null && !(result instanceof Undefined)) break block25;
                    try {
                        if (codeReader == null) return null;
                        codeReader.close();
                        return null;
                    }
                    catch (IOException iOException) {}
                    return null;
                }
                if (!(result instanceof NativeJavaObject)) break block26;
                Object object = ((NativeJavaObject)result).unwrap();
                try {
                    if (codeReader == null) return object;
                    codeReader.close();
                    return object;
                }
                catch (IOException iOException) {}
                return object;
            }
            if (!result.getClass().getName().equals("org.mozilla.javascript.InterpretedFunction")) break block27;
            try {
                if (codeReader == null) return null;
                codeReader.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
        Object object = result;
        try {
            if (codeReader == null) return object;
            codeReader.close();
            return object;
        }
        catch (IOException iOException) {}
        return object;
        catch (WrappedException e) {
            block28: {
                Throwable wrapped = e.getWrappedException();
                if (wrapped instanceof ScriptExecutionException) {
                    throw wrapped;
                }
                if (!(wrapped instanceof Throwable)) break block28;
                throw new ScriptExecutionException(wrapped.getMessage(), e.columnNumber(), e.lineSource(), "JavaError", this.getExceptionStackTrace(script, e.lineNumber()), wrapped);
                {
                    catch (Throwable throwable) {
                        try {
                            if (codeReader == null) throw throwable;
                            codeReader.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                }
            }
            try {
                if (codeReader == null) return null;
                codeReader.close();
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
            catch (EcmaError e2) {
                throw new ScriptExecutionException(e2.getErrorMessage(), e2.columnNumber(), e2.lineSource(), e2.getName(), this.getExceptionStackTrace(script, e2.lineNumber()), null);
                catch (JavaScriptException e3) {
                    String message = e3.getValue() != null ? e3.getValue().toString() : null;
                    throw new ScriptExecutionException(message, e3.lineNumber(), e3.lineSource(), "ScriptException", this.getExceptionStackTrace(script, e3.lineNumber()), null);
                }
                catch (EvaluatorException e4) {
                    throw new ScriptExecutionException(e4.getMessage(), e4.columnNumber(), e4.lineSource(), "SyntaxError", this.getExceptionStackTrace(script, e4.lineNumber()), null);
                }
                catch (RhinoException e5) {
                    throw new ScriptExecutionException("Error running script", e5.columnNumber(), e5.lineSource(), "Error", this.getExceptionStackTrace(script, e5.lineNumber()), null);
                }
            }
        }
    }

    protected List<IScriptDebugFrame> getExceptionStackTrace(Script script, int lineNumber) {
        ArrayList<IScriptDebugFrame> stackTrace = new ArrayList<IScriptDebugFrame>(this.getStackTrace());
        if (script != null && !script.equals((Object)((IScriptDebugFrame)stackTrace.get(0)).getScript())) {
            stackTrace.add(0, (IScriptDebugFrame)new ScriptDebugFrame(script, lineNumber, 1));
        }
        return stackTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context getContext() {
        Context context = Context.getCurrentContext();
        if (context == null) {
            ContextFactory contextFactory = ContextFactory.getGlobal();
            synchronized (contextFactory) {
                context = Context.enter();
            }
        }
        return context;
    }

    public void terminateCurrent() {
        ((ObservingContextFactory)ContextFactory.getGlobal()).terminate(this.mContext);
    }

    public void setDebugger(Debugger debugger) {
        this.mDebugger = debugger;
    }

    protected Debugger getDebugger() {
        return this.mDebugger;
    }

    public synchronized void registerJar(URL url) {
        RhinoClassLoader.registerURL((IScriptEngine)this, url);
    }

    public synchronized void reset() {
        RhinoClassLoader.unregisterEngine(this);
        super.reset();
        this.setupEngine();
    }

    protected Object internalGetVariable(String name) {
        return RhinoScriptEngine.getVariable((Scriptable)this.mScope, name);
    }

    protected Map<String, Object> internalGetVariables() {
        return RhinoScriptEngine.getVariables((Scriptable)this.mScope);
    }

    public static Map<String, Object> getVariables(Scriptable scope) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        Object[] objectArray = scope.getIds();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            Object value = RhinoScriptEngine.getVariable(scope, key.toString());
            if (value == null || !value.getClass().getName().startsWith("org.mozilla.javascript.gen")) {
                result.put(key.toString(), value);
            }
            ++n2;
        }
        Scriptable parent = scope.getParentScope();
        if (parent != null) {
            result.putAll(RhinoScriptEngine.getVariables(parent));
        }
        return result;
    }

    public static Object getVariable(Scriptable scope, String name) {
        Object value = scope.get(name, scope);
        if (value instanceof NativeJavaObject) {
            return ((NativeJavaObject)value).unwrap();
        }
        return value;
    }

    protected boolean internalHasVariable(String name) {
        Object value = this.mScope.get(name, (Scriptable)this.mScope);
        return !Scriptable.NOT_FOUND.equals(value);
    }

    protected void internalSetVariable(String name, Object content) {
        if (!JavaScriptHelper.isSaveName((String)name)) {
            throw new RuntimeException("\"" + name + "\" is not a valid JavaScript variable name");
        }
        ScriptableObject scope = this.mScope;
        Object jsOut = this.internaljavaToJS(content, (Scriptable)scope);
        scope.put(name, (Scriptable)scope, jsOut);
    }

    protected Object internalRemoveVariable(String name) {
        Object result = this.getVariable(name);
        this.mScope.delete(name);
        return result;
    }

    private Object internaljavaToJS(Object value, Scriptable scope) {
        Object result = null;
        result = this.isPrimitiveType(value) || value instanceof Scriptable ? value : (value instanceof Character ? String.valueOf(((Character)value).charValue()) : this.getContext().getWrapFactory().wrap(this.getContext(), scope, value, null));
        return result;
    }

    private boolean isPrimitiveType(Object value) {
        return value instanceof String || value instanceof Number || value instanceof Boolean;
    }

    public String getSaveVariableName(String name) {
        return JavaScriptHelper.getSaveName((String)name);
    }
}

