/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.ease.lang.unittest.runtime.ITestEntity;
import org.eclipse.ease.lang.unittest.runtime.TestStatus;
import org.eclipse.ease.lang.unittest.ui.handlers.AbstractViewToolbarHandler;
import org.eclipse.ease.lang.unittest.ui.views.UnitTestView;
import org.eclipse.ease.ui.tools.ToggleHandler;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ToggleTestFilter
extends ToggleHandler {
    private Filter fFilter = null;

    protected void executeToggle(ExecutionEvent event, boolean checked) {
        UnitTestView view = AbstractViewToolbarHandler.getView(event, UnitTestView.class);
        if (view != null) {
            if (checked) {
                if (this.fFilter == null) {
                    this.fFilter = new Filter();
                }
                view.getFileTreeViewer().addFilter((ViewerFilter)this.fFilter);
                view.getTableViewer().addFilter((ViewerFilter)this.fFilter);
            } else if (this.fFilter != null) {
                view.getFileTreeViewer().removeFilter((ViewerFilter)this.fFilter);
                view.getTableViewer().removeFilter((ViewerFilter)this.fFilter);
                this.fFilter = null;
            }
        }
    }

    private class Filter
    extends ViewerFilter {
        private Filter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ITestEntity) {
                TestStatus status = ((ITestEntity)element).getStatus();
                return status != TestStatus.PASS;
            }
            return true;
        }

        public boolean isFilterProperty(Object element, String property) {
            return "test status".equals(property);
        }
    }
}

