/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.completion.AbstractCompletionParser;
import org.eclipse.jface.text.Position;

public abstract class CompletionContext
implements ICompletionContext {
    private static final Pattern JAVA_PACKAGE_PATTERN = Pattern.compile("([A-Za-z]+\\.?)+");
    private final IScriptEngine fScriptEngine;
    private Object fResource;
    private ScriptType fScriptType;
    private String fOriginalCode = "";
    private final Map<Object, String> fIncludes = new HashMap<Object, String>();
    private Collection<ModuleDefinition> fLoadedModules = null;
    private Class<? extends Object> fReferredClazz;
    private String fFilter = "";
    private ICompletionContext.Type fType = ICompletionContext.Type.UNKNOWN;
    private String fPackage;
    private String fCaller = "";
    private int fParameterOffset = -1;
    private int fOffset;
    private int fSelectionRange;

    public CompletionContext(IScriptEngine scriptEngine, ScriptType scriptType) {
        this.fScriptEngine = scriptEngine;
        this.fScriptType = scriptType;
        if (this.fScriptType == null && this.fScriptEngine != null) {
            this.fScriptType = (ScriptType)this.fScriptEngine.getDescription().getSupportedScriptTypes().get(0);
        }
    }

    public ICompletionContext.Type getType() {
        return this.fType;
    }

    public Class<? extends Object> getReferredClazz() {
        return this.fReferredClazz;
    }

    public void calculateContext(Object resource, String code, int offset, int selectionRange) {
        this.fOffset = offset;
        this.fSelectionRange = selectionRange;
        this.fIncludes.clear();
        this.fLoadedModules = null;
        this.fResource = resource;
        this.fOriginalCode = code;
        this.fReferredClazz = null;
        this.fFilter = "";
        this.addInclude(this.getOriginalCode());
        code = this.simplifyCode();
        this.parseCode(code);
    }

    protected void parseCode(String code) {
        if (this.getType() == ICompletionContext.Type.UNKNOWN) {
            int dotDelimiter = code.lastIndexOf(46);
            if (dotDelimiter == -1) {
                this.fReferredClazz = null;
                this.fType = code.endsWith(")") ? ICompletionContext.Type.UNKNOWN : ICompletionContext.Type.NONE;
                this.fFilter = code;
            } else {
                this.fFilter = code.substring(dotDelimiter + 1);
                this.fReferredClazz = this.getClazz(code.substring(0, dotDelimiter).trim());
                if (this.fReferredClazz == null && JAVA_PACKAGE_PATTERN.matcher(code.subSequence(0, dotDelimiter)).matches()) {
                    this.fType = ICompletionContext.Type.PACKAGE;
                    this.fPackage = code.subSequence(0, dotDelimiter).toString();
                }
            }
        }
    }

    protected String simplifyCode() {
        int lineFeedPosition = this.getOriginalCode().lastIndexOf(10);
        String code = lineFeedPosition > 0 ? this.getOriginalCode().substring(lineFeedPosition) : this.getOriginalCode();
        code = code.trim();
        code = this.replaceStringLiterals(code);
        if (this.fType == ICompletionContext.Type.STRING_LITERAL) {
            int openingBracket;
            if (!code.isEmpty() && (openingBracket = CompletionContext.findMatchingBracket(String.valueOf(code) + ")", code.length())) != -1) {
                this.fCaller = code.substring(0, openingBracket);
                String callerParameters = code.substring(openingBracket + 1);
                callerParameters = CompletionContext.removeMethodCalls(callerParameters);
                this.fParameterOffset = callerParameters.split(",").length - 1;
            }
            return code;
        }
        Collection<Bracket> brackets = CompletionContext.matchBrackets(code, '(', ')');
        int truncatePosition = -1;
        for (Bracket bracket : brackets) {
            if (bracket.fStart < 0 || bracket.fEnd != -1) continue;
            truncatePosition = Math.max(truncatePosition, bracket.fStart + 1);
        }
        int pos = code.length() - 1;
        while (pos >= 0) {
            char c = code.charAt(pos);
            if ((c == ' ' || c == '\t' || c == ',' || c == '!' || c == '=' || c == '<' || c == '>' || c == '+' || c == '-' || c == '*' || c == '/' || c == '%' || c == '&' || c == '|' || c == '^') && CompletionContext.getBracket(brackets, pos) == null) {
                truncatePosition = Math.max(truncatePosition, pos + 1);
                break;
            }
            --pos;
        }
        if (truncatePosition != -1) {
            code = code.substring(truncatePosition);
        }
        return code;
    }

    private static int countOccurrence(String string, char character) {
        int count = 0;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == character) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    private static String removeMethodCalls(String code) {
        int closingBracket = code.lastIndexOf(41);
        while (closingBracket != -1) {
            int openingBracket = CompletionContext.findMatchingBracket(code, closingBracket);
            if (openingBracket == -1) {
                return code;
            }
            code = String.valueOf(code.substring(0, openingBracket)) + code.substring(closingBracket + 1);
            closingBracket = code.lastIndexOf(41);
        }
        return code;
    }

    /*
     * Unable to fully structure code
     */
    private Class<? extends Object> getClazz(String code) {
        block13: {
            block14: {
                code = code.trim();
                parameters = null;
                if (code.endsWith(")")) {
                    bracketOpenPosition = CompletionContext.findMatchingBracket(code, code.length() - 1);
                    parameters = code.substring(bracketOpenPosition + 1, code.length() - 1);
                    code = code.substring(0, bracketOpenPosition);
                }
                try {
                    clazz = CompletionContext.class.getClassLoader().loadClass(code);
                    this.fType = parameters != null ? ICompletionContext.Type.CLASS_INSTANCE : ICompletionContext.Type.STATIC_CLASS;
                    return clazz;
                }
                catch (ClassNotFoundException v0) {
                    dotDelimiter = code.lastIndexOf(46);
                    if (dotDelimiter == -1) {
                        if (parameters != null) {
                            method = this.getMethodDefinition(code);
                            if (method != null) {
                                this.fType = ICompletionContext.Type.CLASS_INSTANCE;
                                return method.getReturnType();
                            }
                            return null;
                        }
                        field = this.getFieldDefinition(code);
                        if (field != null) {
                            this.fType = ICompletionContext.Type.CLASS_INSTANCE;
                            return field.getType();
                        }
                        clazz = this.getVariableClazz(code);
                        if (clazz != null) {
                            this.fType = ICompletionContext.Type.CLASS_INSTANCE;
                            return clazz;
                        }
                        clazz = this.parseVariableType(code);
                        if (clazz != null) {
                            this.fType = ICompletionContext.Type.CLASS_INSTANCE;
                            return clazz;
                        }
                        return null;
                    }
                    keyWord = code.substring(dotDelimiter + 1);
                    if ((code = code.substring(0, dotDelimiter).trim()).isEmpty() || (clazz = this.getClazz(code)) == null) break block13;
                    if (parameters == null) break block14;
                    var9_10 = clazz.getMethods();
                    var8_12 = var9_10.length;
                    var7_14 = 0;
                    ** while (var7_14 < var8_12)
                }
lbl-1000:
                // 1 sources

                {
                    method = var9_10[var7_14];
                    if (method.getName().matches(keyWord)) {
                        this.fType = ICompletionContext.Type.CLASS_INSTANCE;
                        return method.getReturnType();
                    }
                    ++var7_14;
                    continue;
lbl46:
                    // 1 sources

                    break block13;
                }
            }
            var9_11 = clazz.getFields();
            var8_13 = var9_11.length;
            var7_15 = 0;
            while (var7_15 < var8_13) {
                field = var9_11[var7_15];
                if (field.getName().matches(keyWord)) {
                    this.fType = ICompletionContext.Type.CLASS_INSTANCE;
                    return field.getType();
                }
                ++var7_15;
            }
        }
        return null;
    }

    protected Class<? extends Object> parseVariableType(String name) {
        ArrayList<String> sources = new ArrayList<String>();
        sources.add(this.getOriginalCode());
        sources.addAll(this.getIncludedResources().values());
        Pattern pattern = Pattern.compile("@type\\s([a-zA-Z\\.]+)\\s*$\\s*.*?" + Pattern.quote(name) + "\\s*=", 8);
        for (String source : sources) {
            Matcher matcher = pattern.matcher(source);
            if (!matcher.find()) continue;
            try {
                return CompletionContext.class.getClassLoader().loadClass(matcher.group(1));
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        return null;
    }

    private Method getMethodDefinition(String code) {
        for (ModuleDefinition definition : this.getLoadedModules()) {
            for (Method method : definition.getMethods()) {
                if (!method.getName().equals(code)) continue;
                return method;
            }
        }
        return null;
    }

    private Field getFieldDefinition(String code) {
        for (ModuleDefinition definition : this.getLoadedModules()) {
            for (Field field : definition.getFields()) {
                if (!field.getName().equals(code)) continue;
                return field;
            }
        }
        return null;
    }

    protected Class<? extends Object> getVariableClazz(String name) {
        Object variable;
        if (this.getScriptEngine() != null && (variable = this.getScriptEngine().getVariable(name)) != null) {
            return variable.getClass();
        }
        return null;
    }

    private static int findMatchingBracket(String string, int offset) {
        int openBrackets = 0;
        do {
            if (string.charAt(offset) == ')') {
                ++openBrackets;
                continue;
            }
            if (string.charAt(offset) != '(') continue;
            --openBrackets;
        } while (openBrackets > 0 && --offset >= 0);
        return openBrackets > 0 ? -1 : offset + 1;
    }

    public String replaceStringLiterals(String code) {
        StringBuilder simplifiedString = new StringBuilder();
        StringBuilder literalContent = new StringBuilder();
        Character currentLiteral = null;
        int index = 0;
        while (index < code.length()) {
            if (this.isLiteral(code.charAt(index)) && (index == 0 || code.charAt(index - 1) != '\\')) {
                if (currentLiteral == null) {
                    currentLiteral = Character.valueOf(code.charAt(index));
                } else if (currentLiteral.charValue() == code.charAt(index)) {
                    literalContent.delete(0, literalContent.length());
                    simplifiedString.append(currentLiteral);
                    simplifiedString.append(currentLiteral);
                    currentLiteral = null;
                }
            } else if (currentLiteral == null) {
                simplifiedString.append(code.charAt(index));
            } else {
                literalContent.append(code.charAt(index));
            }
            ++index;
        }
        if (currentLiteral != null) {
            this.fFilter = literalContent.toString();
            this.fType = ICompletionContext.Type.STRING_LITERAL;
        }
        return simplifiedString.toString();
    }

    protected abstract boolean isLiteral(char var1);

    private void addLoadedModules(String code) {
        List<Position> modulePositions = AbstractCompletionParser.findInvocations("loadModule(java.lang.String)", code);
        for (Position position : modulePositions) {
            String candidate;
            String call = code.substring(position.getOffset(), position.getOffset() + position.getLength());
            String[] parameters = AbstractCompletionParser.getParameters(call);
            if (parameters.length <= 0 || (candidate = parameters[0].trim()).charAt(0) != candidate.charAt(candidate.length() - 1) || candidate.charAt(0) != '\"' && candidate.charAt(0) != '\'') continue;
            String moduleName = ModuleHelper.resolveName((String)candidate.substring(1, candidate.length() - 1));
            ScriptService scriptService = ScriptService.getInstance();
            ModuleDefinition moduleDefinition = (ModuleDefinition)scriptService.getAvailableModules().get(moduleName);
            if (moduleDefinition == null) continue;
            this.addLoadedModule(moduleDefinition);
        }
    }

    private void addLoadedModule(ModuleDefinition definition) {
        this.fLoadedModules.add(definition);
        ScriptService scriptService = ScriptService.getInstance();
        for (String dependency : definition.getDependencies().keySet()) {
            ModuleDefinition dependencyDefinition = (ModuleDefinition)scriptService.getAvailableModules().get(dependency);
            if (dependencyDefinition == null) continue;
            this.addLoadedModule(dependencyDefinition);
        }
    }

    private void addInclude(String code) {
        List<Position> includePositions = AbstractCompletionParser.findInvocations("include(java.lang.String)", code);
        for (Position position : includePositions) {
            try {
                Object includeResource;
                String candidate;
                String call = code.substring(position.getOffset(), position.getOffset() + position.getLength());
                String[] parameters = AbstractCompletionParser.getParameters(call);
                if (parameters.length <= 0 || (candidate = parameters[0].trim()).charAt(0) != candidate.charAt(candidate.length() - 1) || candidate.charAt(0) != '\"' && candidate.charAt(0) != '\'' || (includeResource = ResourceTools.resolveFile((Object)candidate.substring(1, candidate.length() - 1), (Object)this.getResource(), (boolean)true)) == null || this.fIncludes.containsKey(includeResource)) continue;
                this.fIncludes.put(includeResource, ResourceTools.resourceToString((Object)includeResource));
                this.addInclude(this.fIncludes.get(includeResource));
            }
            catch (Exception exception) {}
        }
    }

    public String getOriginalCode() {
        return this.fOriginalCode;
    }

    public String getProcessedCode() {
        return this.getOriginalCode();
    }

    public Object getResource() {
        return this.fResource;
    }

    public IScriptEngine getScriptEngine() {
        return this.fScriptEngine;
    }

    public ScriptType getScriptType() {
        return this.fScriptType;
    }

    public Collection<ModuleDefinition> getLoadedModules() {
        if (this.fLoadedModules == null) {
            this.fLoadedModules = new HashSet<ModuleDefinition>();
            ScriptService scriptService = ScriptService.getInstance();
            this.addLoadedModule((ModuleDefinition)scriptService.getAvailableModules().get("/System/Environment"));
            this.addLoadedModules(this.getOriginalCode());
            for (String includeContent : this.fIncludes.values()) {
                if (includeContent == null) continue;
                this.addLoadedModules(includeContent);
            }
            if (this.getScriptEngine() != null) {
                for (ModuleDefinition definition : ModuleHelper.getLoadedModules((IScriptEngine)this.getScriptEngine())) {
                    this.addLoadedModule(definition);
                }
            }
        }
        return this.fLoadedModules;
    }

    public Map<Object, String> getIncludedResources() {
        return this.fIncludes;
    }

    public String getFilter() {
        return this.fFilter;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getSelectionRange() {
        return this.fSelectionRange;
    }

    public String getPackage() {
        return this.fPackage;
    }

    public String getCaller() {
        return this.fCaller;
    }

    public int getParameterOffset() {
        return this.fParameterOffset;
    }

    private static Collection<Bracket> matchBrackets(String code, char openChar, char closeChar) {
        ArrayList<Bracket> brackets = new ArrayList<Bracket>();
        int pos = 0;
        while (pos < code.length()) {
            char c = code.charAt(pos);
            if (c == openChar) {
                brackets.add(0, new Bracket(pos, -1));
            } else if (c == closeChar) {
                boolean found = false;
                for (Bracket bracket : brackets) {
                    if (bracket.fEnd != -1) continue;
                    bracket.fEnd = pos;
                    found = true;
                    break;
                }
                if (!found) {
                    brackets.add(0, new Bracket(-1, pos));
                }
            }
            ++pos;
        }
        return brackets;
    }

    private static Bracket getBracket(Collection<Bracket> brackets, int pos) {
        for (Bracket bracket : brackets) {
            if (bracket.fStart == -1 || bracket.fStart > pos || bracket.fEnd == -1 || bracket.fEnd <= pos) continue;
            return bracket;
        }
        return null;
    }

    public static class Bracket {
        private int fStart = -1;
        private int fEnd = -1;

        public Bracket(int start, int end) {
            this.fStart = start;
            this.fEnd = end;
        }
    }
}

