/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.helpgenerator.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.ease.helpgenerator.model.ExceptionValue;
import org.eclipse.ease.helpgenerator.model.Field;
import org.eclipse.ease.helpgenerator.model.Parameter;
import org.eclipse.ease.helpgenerator.model.ReturnValue;
import org.eclipse.ease.helpgenerator.model.ScriptExample;

public class Method
extends Field {
    private final Collection<String> fAliases;
    private final List<Parameter> fParameters;
    private final List<ExceptionValue> fExceptions;
    private List<ScriptExample> fExamples;
    private final ReturnValue fReturnType;

    public Method(String name, String comment, String deprecationMessage, Collection<String> aliases, ReturnValue returnType, List<Parameter> parameters, List<ExceptionValue> exceptions, List<ScriptExample> examples) {
        super(name, comment, deprecationMessage);
        this.fAliases = aliases;
        this.fReturnType = returnType;
        this.fParameters = parameters;
        this.fExceptions = exceptions;
        this.fExamples = examples != null ? examples : Collections.emptyList();
    }

    public Collection<String> getAliases() {
        return this.fAliases;
    }

    public List<Parameter> getParameters() {
        return this.fParameters;
    }

    public ReturnValue getReturnType() {
        return this.fReturnType;
    }

    public List<ExceptionValue> getExceptions() {
        return this.fExceptions;
    }

    public List<ScriptExample> getExamples() {
        return this.fExamples;
    }

    public void fetchDetailsFrom(Method method) {
        Optional<Parameter> candidate;
        if (this.getComment().isEmpty()) {
            this.setComment(method.getComment());
        }
        if (this.getDeprecationMessage() == null) {
            this.setDeprecationMessage(method.getDeprecationMessage());
        }
        if (this.getExamples().isEmpty()) {
            this.fExamples = method.getExamples();
        }
        if (this.getReturnType().getComment().isEmpty()) {
            this.getReturnType().setComment(method.getReturnType().getComment());
        }
        for (Parameter parameter : this.getParameters()) {
            if (!parameter.getComment().isEmpty() || !(candidate = method.getParameters().stream().filter(p -> p.getName().equals(parameter.getName())).findFirst()).isPresent()) continue;
            parameter.setComment(candidate.get().getComment());
        }
        for (ExceptionValue exception : this.getExceptions()) {
            if (!exception.getComment().isEmpty() || !(candidate = method.getExceptions().stream().filter(e -> e.getTypeName().equals(exception.getTypeName())).findFirst()).isPresent()) continue;
            exception.setComment(((ExceptionValue)candidate.get()).getComment());
        }
    }

    public String toString() {
        String parameters = this.getParameters().stream().map(p -> p.getName()).collect(Collectors.joining(", "));
        return this.getReturnType().getTypeName() + " " + this.getName() + "(" + parameters + ")";
    }
}

