/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.tools.actionscript.debug;

import java.util.Date;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.swt.tools.actionscript.ActionScriptCorePlugin;

public class ActionScriptProcess extends PlatformObject implements IProcess {
	ActionScriptDebugTarget target;
	ILaunch launch;
	boolean terminated;
	String processName;
	
	public ActionScriptProcess(ILaunch launch) {
		this.launch = launch;
		fireDebugEvent(DebugEvent.CREATE);
	}
	
	public ActionScriptProcess(ActionScriptDebugTarget target, ILaunch launch, String processName) {
		this.target = target;
		this.launch = launch;
		this.processName = processName + " (" + new Date() + ")";
	}

	public String getAttribute(String key) {
		return null;
	}

	public int getExitValue() throws DebugException {
		return 0;
	}

	public String getLabel() {
		return processName;
	}

	public ILaunch getLaunch() {
		return launch;
	}

	public IStreamsProxy getStreamsProxy() {
		return null;
	}

	public void setAttribute(String key, String value) {
	}

	public Object getAdapter(Class adapter) {
		if (adapter.equals(IProcess.class)) return this;
		return super.getAdapter(adapter);
	}

	public boolean canTerminate() {
		return !terminated;
	}

	public boolean isTerminated() {
		return terminated;
	}

	public void terminate() throws DebugException {
		terminated = true;
		if (target != null) target.session.terminate();
		fireDebugEvent(DebugEvent.TERMINATE);
	}

	private void fireDebugEvent(int type) {
		DebugEvent event = new DebugEvent(this, type);
		DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[] {event});
	}

	public String getModelIdentifier() {
		return ActionScriptCorePlugin.PLUGIN_ID;
	}

}
