/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.tools.actionscript.debug;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptLineMapper.FileLocation;

import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SuspendReason;
import flash.tools.debugger.events.BreakEvent;
import flash.tools.debugger.events.DebugEvent;
import flash.tools.debugger.events.SwfLoadedEvent;

public class ActionScriptDebugEventDispatcher extends Job {
	static final int CLIENT_REQUEST = org.eclipse.debug.core.DebugEvent.CLIENT_REQUEST;
	static final int BREAKPOINT = org.eclipse.debug.core.DebugEvent.BREAKPOINT;
	
	ActionScriptDebugTarget target;

	public ActionScriptDebugEventDispatcher(ActionScriptDebugTarget target) {
		super("ActionScript Event Dispatcher");
		this.target = target;
	}

	protected IStatus run(IProgressMonitor monitor) {
		if (target.isTerminated()) return Status.CANCEL_STATUS;
		Session session = target.session;

		//FIXME waitForEvent looks promising, but wasn't returning,
		// even when I knew there were events. Revisit this.
//		try {
//			session.waitForEvent();
//		} catch (NotConnectedException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		} catch (InterruptedException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
		DebugEvent nextEvent = session.nextEvent();
		while (nextEvent != null && !target.isTerminated()) {
			handleEvent(nextEvent);
			nextEvent = session.nextEvent();
		}
		if (!target.isTerminated()) {
			schedule(500);
		}
		return Status.OK_STATUS;
	}

	void handleEvent(DebugEvent nextEvent) {
		if (nextEvent instanceof BreakEvent) {
			handleBreak((BreakEvent)nextEvent);
		} else if (nextEvent instanceof SwfLoadedEvent) {
			handleSwfLoaded((SwfLoadedEvent)nextEvent);
		}
	}

	void handleSwfLoaded(SwfLoadedEvent nextEvent) {
		IBreakpointManager breakpointManager = target.getBreakpointManager();
		IBreakpoint[] breakpoints = breakpointManager.getBreakpoints();
		for (int i = 0; i < breakpoints.length; i++) {
			if (breakpoints[i] instanceof IJavaBreakpoint) {
				try {
					target.installBreakpoint((IJavaLineBreakpoint) breakpoints[i]);
				} catch (PlayerDebugException e) {
					e.printStackTrace();
				} catch (CoreException e) {
					e.printStackTrace();
				}
			}
		}
	}

	void handleBreak(BreakEvent nextEvent) {
		try {
			Session session = target.session;
			switch (session.suspendReason()) {
				case SuspendReason.Unknown:
				case SuspendReason.ScriptLoaded:
					if (session.isSuspended())
						session.resume();
					return;
			}
		} catch (PlayerDebugException e1) {
			e1.printStackTrace();
		}
		
		IBreakpointManager breakpointManager = target.getBreakpointManager();
		IBreakpoint[] breakpoints = breakpointManager.getBreakpoints();
		for (int i = 0; i < breakpoints.length; i++) {
			if (breakpoints[i] instanceof IJavaLineBreakpoint) {
				IJavaLineBreakpoint bp = (IJavaLineBreakpoint) breakpoints[i];
				try {
					int id = bp.getMarker().getAttribute("ASID", -1);
					ActionScriptLineMapper mapper = ActionScriptLineMapper.getInstance();
					FileLocation fileLocation = mapper.getActionScriptLocation(bp);
					if (fileLocation != null && fileLocation.lineNumber == nextEvent.line &&
							id == nextEvent.fileId) {
						if (target.isStepping) target.isStepping = false;
						target.thread.fireSuspendEvent(BREAKPOINT);
						return;
					}
				} catch (CoreException e) {
					e.printStackTrace();
				}
			}
		}
		if (target.isStepping()) {
			target.stepEnd();
		} else {
			target.thread.fireSuspendEvent(CLIENT_REQUEST);
		}
	}

}
