/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.core.test.unit.internal;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.platform.discovery.core.internal.favorites.SearchFavoritesPersistenceUtil;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.persistence.DestinationItemPair;
import org.eclipse.platform.discovery.runtime.internal.persistence.IMementoContentManager;
import org.eclipse.platform.discovery.runtime.internal.persistence.MementoContentManagerException;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.jmock.core.Constraint;

public class SearchFavoritesPersistenceUtilTest
extends MockObjectTestCase {
    private SearchFavoritesPersistenceUtil util;
    private Mock<SearchFavoritesPersistenceUtil.IPersistenceContext<DestinationItemPair>> persistenceContextMock;
    private File persistenceFile = null;
    private Mock<ILongOperationRunner> operationRunnerMock;
    private Mock<IMemento> memento;
    private Mock<IMementoContentManager<Object>> mementoContentManager;
    private int mementoSavedCount;
    private Mock<ISearchDestination> searchDestination;
    private DestinationItemPair pair_1;
    private DestinationItemPair pair_2;

    protected void setUp() throws Exception {
        this.mementoContentManager = this.mock(IMementoContentManager.class);
        this.operationRunnerMock = this.mock(ILongOperationRunner.class);
        this.memento = this.mock(IMemento.class);
        this.mementoSavedCount = 0;
        this.setupPersistenceContext();
        this.searchDestination = this.mock(ISearchDestination.class);
        this.pair_1 = new DestinationItemPair((ISearchDestination)this.searchDestination.proxy(), new Object());
        this.pair_2 = new DestinationItemPair((ISearchDestination)this.searchDestination.proxy(), new Object());
        this.util = new SearchFavoritesPersistenceUtil((SearchFavoritesPersistenceUtil.IPersistenceContext)this.persistenceContextMock.proxy()){

            protected IMemento provideStorageMemento() throws IOException, WorkbenchException {
                return (IMemento)SearchFavoritesPersistenceUtilTest.this.memento.proxy();
            }

            protected IMemento createStorageMemento() {
                return (IMemento)SearchFavoritesPersistenceUtilTest.this.memento.proxy();
            }

            protected void saveMemento(IMemento m) throws IOException {
                SearchFavoritesPersistenceUtilTest.assertTrue((String)"Unexpected memento", (boolean)m.equals(SearchFavoritesPersistenceUtilTest.this.memento.proxy()));
                SearchFavoritesPersistenceUtilTest searchFavoritesPersistenceUtilTest = SearchFavoritesPersistenceUtilTest.this;
                searchFavoritesPersistenceUtilTest.mementoSavedCount = searchFavoritesPersistenceUtilTest.mementoSavedCount + 1;
            }
        };
    }

    public void testLoadItems() throws WorkbenchException, IOException, MementoContentManagerException {
        HashSet<DestinationItemPair> itemsToBeLoadedFromMemento = new HashSet<DestinationItemPair>(Arrays.asList(this.pair_1, this.pair_2));
        this.mementoContentManager.expects(this.once()).method("loadContent").with((Constraint)this.eq(this.memento.proxy()), (Constraint)this.isA(ILongOperationRunner.class)).will(this.returnValue(itemsToBeLoadedFromMemento));
        Set loadedItems = this.util.loadItems((ILongOperationRunner)this.operationRunnerMock.proxy());
        SearchFavoritesPersistenceUtilTest.assertEquals((String)"2 items are expected to be loaded", (int)2, (int)loadedItems.size());
        SearchFavoritesPersistenceUtilTest.assertTrue((String)"Pair 1 not found", (boolean)loadedItems.contains(this.pair_1));
        SearchFavoritesPersistenceUtilTest.assertTrue((String)"Pair 2 not found", (boolean)loadedItems.contains(this.pair_2));
    }

    public void testAddItems() throws WorkbenchException, IOException, MementoContentManagerException {
        HashSet<DestinationItemPair> itemsToBeLoadedFromMemento = new HashSet<DestinationItemPair>(Arrays.asList(this.pair_2));
        this.mementoContentManager.expects(this.once()).method("loadContent").with((Constraint)this.eq(this.memento.proxy()), (Constraint)this.isA(ILongOperationRunner.class)).will(this.returnValue(itemsToBeLoadedFromMemento));
        this.mementoContentManager.expects(this.once()).method("saveContent").with((Constraint)this.eq(this.memento.proxy()), this.collectionWithElements(2, new Object[]{this.pair_1, this.pair_2}), (Constraint)this.isA(ILongOperationRunner.class));
        this.util.addItems(new HashSet<DestinationItemPair>(Arrays.asList(this.pair_1, this.pair_2)), (ILongOperationRunner)this.operationRunnerMock.proxy());
        SearchFavoritesPersistenceUtilTest.assertEquals((String)"Memento should be saved once", (int)1, (int)this.mementoSavedCount);
    }

    public void testDeleteItem() throws IOException, WorkbenchException, MementoContentManagerException {
        HashSet<DestinationItemPair> existingLoadItems = new HashSet<DestinationItemPair>(Arrays.asList(this.pair_1, this.pair_2));
        HashSet<Object> itemsToDelete = new HashSet<Object>(Arrays.asList(this.pair_1.getItem()));
        this.mementoContentManager.expects(this.once()).method("loadContent").with((Constraint)this.eq(this.memento.proxy()), (Constraint)this.isA(ILongOperationRunner.class)).will(this.returnValue(existingLoadItems));
        this.mementoContentManager.expects(this.once()).method("saveContent").with((Constraint)this.eq(this.memento.proxy()), this.collectionWithSingleElement(this.pair_2), (Constraint)this.isA(ILongOperationRunner.class));
        this.util.deleteItems(itemsToDelete, (ILongOperationRunner)this.operationRunnerMock.proxy());
        SearchFavoritesPersistenceUtilTest.assertEquals((String)"Memento should be saved once", (int)1, (int)this.mementoSavedCount);
    }

    private Constraint collectionWithSingleElement(final Object element) {
        return new Constraint(){

            public boolean eval(Object arg0) {
                Collection inCollection = (Collection)arg0;
                boolean result = inCollection.size() == 1 && inCollection.contains(element);
                return result;
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                arg0.append("[<" + element.toString() + ">]");
                return arg0;
            }
        };
    }

    private void setupPersistenceContext() throws IOException {
        this.persistenceContextMock = this.mock(SearchFavoritesPersistenceUtil.IPersistenceContext.class);
        this.persistenceContextMock.stubs().method("getContentManager").will(this.returnValue(this.mementoContentManager.proxy()));
        this.persistenceFile = File.createTempFile("test", null);
        this.persistenceFile.delete();
        this.persistenceContextMock.stubs().method("getFile").will(this.returnValue(this.persistenceFile));
    }
}

