/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.core.test.unit.internal;

import java.util.Arrays;
import java.util.List;
import org.eclipse.platform.discovery.core.api.ISearchContext;
import org.eclipse.platform.discovery.core.internal.ISearchSession;
import org.eclipse.platform.discovery.core.internal.SearchConsoleController;
import org.eclipse.platform.discovery.core.internal.console.ISearchConsoleControllerOutputView;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.testutils.utils.model.DestinationCategoryDescriptionBuilder;
import org.eclipse.platform.discovery.testutils.utils.model.ObjectTypeDescriptionBuilder;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.platform.discovery.util.api.env.IErrorHandler;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.internal.session.IHistoryTrack;
import org.eclipse.platform.discovery.util.internal.session.ISessionManager;
import org.jmock.core.Constraint;

public abstract class SearchConsoleControllerFixture
extends MockObjectTestCase {
    protected static final String searchSessionId = "searchSessionId";
    protected static final String defaultSessionId = "defaultSessionId";
    protected SearchConsoleController testController;
    protected Mock<ISearchProviderConfiguration> providerConfig;
    protected Mock<ISearchConsoleControllerOutputView> view;
    protected IObjectTypeDescription objectType_1;
    protected IObjectTypeDescription objectType_2;
    protected static final String OBJECT_TYPE_1_ID = "object1id";
    protected static final String OBJECT_TYPE_2_ID = "object2id";
    protected Mock<ISearchProviderDescription> searchProviderDescr_1;
    protected IDestinationCategoryDescription destinationCategory1;
    protected IDestinationCategoryDescription destinationCategory2;
    protected IDestinationCategoryDescription destinationCategory3;
    protected List<IDestinationCategoryDescription> destinationCategories_obj1;
    protected List<IDestinationCategoryDescription> destinationCategories_obj2;
    protected Mock<IDiscoveryEnvironment> consoleEnvironment;
    protected Mock<IErrorHandler> errorHandler;
    protected Mock<ILongOperationRunner> operationRunner;
    protected Mock<ISessionManager<ISearchSession>> sessionManager;
    protected Mock<IHistoryTrack<ISearchContext>> sessionHistory;
    protected Mock<ISearchSession> testSession;

    protected void setUp() throws Exception {
        super.setUp();
        this.searchProviderDescr_1 = this.mock(ISearchProviderDescription.class);
        this.setupObjectTypes();
        this.setupSearchProviderConfig();
        this.view = this.mock(ISearchConsoleControllerOutputView.class);
        List<IObjectTypeDescription> objectTypes = Arrays.asList(this.objectType_1, this.objectType_2);
        this.view.expects(this.once()).method("showObjectTypes").with((Constraint)this.eq(objectTypes));
        this.setupSessions();
        this.setupConsoleEnvironment();
        this.testController = new SearchConsoleController((ISearchProviderConfiguration)this.providerConfig.proxy(), (ISearchConsoleControllerOutputView)this.view.proxy(), (IDiscoveryEnvironment)this.consoleEnvironment.proxy(), (ISessionManager)this.sessionManager.proxy(), defaultSessionId);
    }

    private void setupSessions() {
        this.sessionHistory = this.mock(IHistoryTrack.class);
        this.testSession = this.mock(ISearchSession.class);
        this.testSession.stubs().method("historyTrack").will(this.returnValue(this.sessionHistory.proxy()));
        this.sessionManager = this.mock(ISessionManager.class);
    }

    private void setupConsoleEnvironment() {
        this.operationRunner = this.mock(ILongOperationRunner.class);
        this.errorHandler = this.mock(IErrorHandler.class);
        this.consoleEnvironment = this.mock(IDiscoveryEnvironment.class);
        this.consoleEnvironment.stubs().method("operationRunner").will(this.returnValue(this.operationRunner.proxy()));
        this.consoleEnvironment.stubs().method("errorHandler").will(this.returnValue(this.errorHandler.proxy()));
    }

    private void setupObjectTypes() {
        this.objectType_1 = (IObjectTypeDescription)new ObjectTypeDescriptionBuilder().withId(OBJECT_TYPE_1_ID).object();
        this.objectType_2 = (IObjectTypeDescription)new ObjectTypeDescriptionBuilder().withId(OBJECT_TYPE_2_ID).object();
    }

    private void setupSearchProviderConfig() {
        List<IObjectTypeDescription> objectTypes = Arrays.asList(this.objectType_1, this.objectType_2);
        this.providerConfig = this.mock(ISearchProviderConfiguration.class);
        this.providerConfig.stubs().method("getObjectTypes").will(this.returnValue(objectTypes));
        this.destinationCategory1 = (IDestinationCategoryDescription)new DestinationCategoryDescriptionBuilder().object();
        this.destinationCategory2 = (IDestinationCategoryDescription)new DestinationCategoryDescriptionBuilder().object();
        this.destinationCategories_obj1 = Arrays.asList(this.destinationCategory1, this.destinationCategory2);
        this.providerConfig.stubs().method("getAvailableDestinationCategoriesForObjectType").with((Constraint)this.eq(this.objectType_1)).will(this.returnValue(this.destinationCategories_obj1));
        this.destinationCategory3 = (IDestinationCategoryDescription)new DestinationCategoryDescriptionBuilder().object();
        this.destinationCategories_obj2 = Arrays.asList(this.destinationCategory3);
        this.providerConfig.stubs().method("getAvailableDestinationCategoriesForObjectType").with((Constraint)this.eq(this.objectType_2)).will(this.returnValue(this.destinationCategories_obj2));
    }
}

