/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.core.test.unit.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.platform.discovery.core.internal.favorites.SearchFavoritesContentManager;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.persistence.DestinationItemPair;
import org.eclipse.platform.discovery.runtime.api.persistence.IMementoLoadProvider;
import org.eclipse.platform.discovery.runtime.api.persistence.IMementoStoreProvider;
import org.eclipse.platform.discovery.runtime.internal.persistence.MementoContentManagerException;
import org.eclipse.platform.discovery.runtime.internal.persistence.util.IPersistenceProviderRegistry;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.internal.longop.CurrentThreadOperationRunner;
import org.eclipse.ui.IMemento;
import org.jmock.core.Constraint;

public class PersistenceFrameworkTest
extends MockObjectTestCase {
    private Mock<IMemento> container = null;
    private DestinationItemPair pair_1;
    private DestinationItemPair pair_2;
    private Mock<ISearchDestination> destination;
    private ILongOperationRunner opRunner;

    protected void setUp() throws Exception {
        super.setUp();
        this.container = this.mock(IMemento.class);
        this.destination = this.mock(ISearchDestination.class);
        this.pair_1 = new DestinationItemPair((ISearchDestination)this.destination.proxy(), new Object());
        this.pair_2 = new DestinationItemPair((ISearchDestination)this.destination.proxy(), new Object());
        this.opRunner = new CurrentThreadOperationRunner((IProgressMonitor)new NullProgressMonitor());
    }

    public void testContentManagerWithWorkingProviders() throws Exception {
        IMemento memento1 = (IMemento)this.mock(IMemento.class).proxy();
        IMemento memento2 = (IMemento)this.mock(IMemento.class).proxy();
        ArrayList<DestinationItemPair> pairsCollection = new ArrayList<DestinationItemPair>();
        pairsCollection.add(this.pair_1);
        pairsCollection.add(this.pair_2);
        ArrayList<IMemento> mementoCollection = new ArrayList<IMemento>();
        mementoCollection.add(memento1);
        mementoCollection.add(memento2);
        HashMap<IMemento, DestinationItemPair> mementoToPairMap = new HashMap<IMemento, DestinationItemPair>();
        mementoToPairMap.put(memento1, this.pair_1);
        mementoToPairMap.put(memento2, this.pair_2);
        HashMap<DestinationItemPair, IMemento> pairToMementoMap = new HashMap<DestinationItemPair, IMemento>();
        pairToMementoMap.put(this.pair_1, memento1);
        pairToMementoMap.put(this.pair_2, memento2);
        this.container.expects(this.atLeastOnce()).method("getChildren").with(ANYTHING).will(this.returnValue(mementoCollection.toArray(new IMemento[0])));
        ArrayList<Object> loadedStorage = new ArrayList<Object>();
        Mock storeProviderObjectType1Mock = this.mock(IMementoStoreProvider.class);
        storeProviderObjectType1Mock.expects(this.atLeastOnce()).method("canStore").with((Constraint)this.same(this.pair_1)).will(this.returnValue(true));
        storeProviderObjectType1Mock.expects(this.atLeastOnce()).method("canStore").with((Constraint)this.not((Constraint)this.same(this.pair_1))).will(this.returnValue(false));
        storeProviderObjectType1Mock.expects(this.once()).method("store").with((Constraint)this.same(this.container.proxy()), (Constraint)this.same(this.pair_1), (Constraint)this.isA(ILongOperationRunner.class));
        Mock storeProviderObjectType2Mock = this.mock(IMementoStoreProvider.class);
        storeProviderObjectType2Mock.expects(this.atLeastOnce()).method("canStore").with((Constraint)this.same(this.pair_2)).will(this.returnValue(true));
        storeProviderObjectType2Mock.expects(this.atLeastOnce()).method("canStore").with((Constraint)this.not((Constraint)this.same(this.pair_2))).will(this.returnValue(false));
        storeProviderObjectType2Mock.expects(this.once()).method("store").with((Constraint)this.same(this.container.proxy()), (Constraint)this.same(this.pair_2), (Constraint)this.isA(ILongOperationRunner.class));
        Mock loadProviderObjectType1Mock = this.mock(IMementoLoadProvider.class);
        loadProviderObjectType1Mock.expects(this.atLeastOnce()).method("canLoad").with((Constraint)this.same(memento1)).will(this.returnValue(true));
        loadProviderObjectType1Mock.expects(this.atLeastOnce()).method("canLoad").with((Constraint)this.same(memento2)).will(this.returnValue(false));
        loadProviderObjectType1Mock.expects(this.atLeastOnce()).method("getChildType").will(this.returnValue(null));
        loadProviderObjectType1Mock.expects(this.once()).method("load").with((Constraint)this.same(memento1), (Constraint)this.isA(ILongOperationRunner.class)).will(this.returnValue(this.appendToCollection(loadedStorage, this.pair_1)));
        Mock loadProviderObjectType2Mock = this.mock(IMementoLoadProvider.class);
        loadProviderObjectType2Mock.expects(this.atLeastOnce()).method("canLoad").with((Constraint)this.same(memento1)).will(this.returnValue(false));
        loadProviderObjectType2Mock.expects(this.atLeastOnce()).method("canLoad").with((Constraint)this.same(memento2)).will(this.returnValue(true));
        loadProviderObjectType2Mock.expects(this.atLeastOnce()).method("getChildType").will(this.returnValue(null));
        loadProviderObjectType2Mock.expects(this.once()).method("load").with((Constraint)this.same(memento2), (Constraint)this.isA(ILongOperationRunner.class)).will(this.returnValue(this.appendToCollection(loadedStorage, this.pair_2)));
        Mock providerRegistry = this.mock(IPersistenceProviderRegistry.class);
        providerRegistry.expects(this.atLeastOnce()).method("collectAllStoreProviders").will(this.returnValue(new HashSet<IMementoStoreProvider>(Arrays.asList((IMementoStoreProvider)storeProviderObjectType1Mock.proxy(), (IMementoStoreProvider)storeProviderObjectType2Mock.proxy()))));
        providerRegistry.expects(this.atLeastOnce()).method("collectAllLoadProviders").will(this.returnValue(new HashSet<IMementoLoadProvider>(Arrays.asList((IMementoLoadProvider)loadProviderObjectType1Mock.proxy(), (IMementoLoadProvider)loadProviderObjectType2Mock.proxy()))));
        SearchFavoritesContentManager contentManager = new SearchFavoritesContentManager((IPersistenceProviderRegistry)providerRegistry.proxy());
        contentManager.saveContent((IMemento)this.container.proxy(), pairsCollection, this.opRunner);
        storeProviderObjectType1Mock.verify();
        storeProviderObjectType2Mock.verify();
        contentManager.loadContent((IMemento)this.container.proxy(), this.opRunner);
        PersistenceFrameworkTest.assertTrue((loadedStorage.containsAll(pairsCollection) && !pairsCollection.isEmpty() ? 1 : 0) != 0);
    }

    public void testContentManagerWithDamagedLoadProviders() {
        IMemento memento1 = (IMemento)this.mock(IMemento.class).proxy();
        IMemento memento2 = (IMemento)this.mock(IMemento.class).proxy();
        ArrayList<IMemento> mementoCollection = new ArrayList<IMemento>();
        mementoCollection.add(memento1);
        mementoCollection.add(memento2);
        this.container.expects(this.atLeastOnce()).method("getChildren").with(ANYTHING).will(this.returnValue(mementoCollection.toArray(new IMemento[0])));
        Mock loadProviderObjectType1Mock = this.mock(IMementoLoadProvider.class);
        loadProviderObjectType1Mock.stubs().method("getChildType").will(this.returnValue(null));
        loadProviderObjectType1Mock.expects(this.atLeastOnce()).method("getDescriptor").will(this.returnValue("loadProviderObjectType1"));
        loadProviderObjectType1Mock.expects(this.atLeastOnce()).method("canLoad").with(ANYTHING).will(this.returnValue(true));
        Mock loadProviderObjectType2Mock = this.mock(IMementoLoadProvider.class);
        loadProviderObjectType2Mock.stubs().method("getChildType").will(this.returnValue(null));
        loadProviderObjectType2Mock.expects(this.atLeastOnce()).method("getDescriptor").will(this.returnValue("loadProviderObjectType2"));
        loadProviderObjectType2Mock.expects(this.atLeastOnce()).method("canLoad").with(ANYTHING).will(this.returnValue(true));
        Mock providerRegistry = this.mock(IPersistenceProviderRegistry.class);
        providerRegistry.expects(this.atLeastOnce()).method("collectAllStoreProviders").will(this.returnValue(new HashSet()));
        providerRegistry.expects(this.atLeastOnce()).method("collectAllLoadProviders").will(this.returnValue(new HashSet<IMementoLoadProvider>(Arrays.asList((IMementoLoadProvider)loadProviderObjectType1Mock.proxy(), (IMementoLoadProvider)loadProviderObjectType2Mock.proxy()))));
        try {
            SearchFavoritesContentManager contentManager = new SearchFavoritesContentManager((IPersistenceProviderRegistry)providerRegistry.proxy());
            contentManager.loadContent((IMemento)this.container.proxy(), this.opRunner);
            PersistenceFrameworkTest.fail((String)"Load provider with same loading type exists. ");
        }
        catch (MementoContentManagerException cme) {
            String errorMessage = cme.getMessage();
            PersistenceFrameworkTest.assertFalse((boolean)"loadProviderObjectType1".equals("loadProviderObjectType2"));
            PersistenceFrameworkTest.assertTrue((boolean)errorMessage.contains("loadProviderObjectType1"));
            PersistenceFrameworkTest.assertTrue((boolean)errorMessage.contains("loadProviderObjectType2"));
        }
    }

    public void testContentManagerWithDamagedStoreProviders() {
        ArrayList<DestinationItemPair> pairsCollection = new ArrayList<DestinationItemPair>();
        pairsCollection.add(this.pair_1);
        pairsCollection.add(this.pair_2);
        Mock storeProviderObjectType1Mock = this.mock(IMementoStoreProvider.class);
        storeProviderObjectType1Mock.expects(this.atLeastOnce()).method("getDescriptor").will(this.returnValue("storeProviderObjectType1"));
        storeProviderObjectType1Mock.expects(this.atLeastOnce()).method("canStore").with(ANYTHING).will(this.returnValue(true));
        Mock storeProviderObjectType2Mock = this.mock(IMementoStoreProvider.class);
        storeProviderObjectType2Mock.expects(this.atLeastOnce()).method("getDescriptor").will(this.returnValue("storeProviderObjectType2"));
        storeProviderObjectType2Mock.expects(this.atLeastOnce()).method("canStore").with(ANYTHING).will(this.returnValue(true));
        Mock providerRegistry = this.mock(IPersistenceProviderRegistry.class);
        providerRegistry.expects(this.atLeastOnce()).method("collectAllStoreProviders").will(this.returnValue(new HashSet<IMementoStoreProvider>(Arrays.asList((IMementoStoreProvider)storeProviderObjectType1Mock.proxy(), (IMementoStoreProvider)storeProviderObjectType2Mock.proxy()))));
        providerRegistry.expects(this.atLeastOnce()).method("collectAllLoadProviders").will(this.returnValue(new HashSet()));
        try {
            SearchFavoritesContentManager contentManager = new SearchFavoritesContentManager((IPersistenceProviderRegistry)providerRegistry.proxy());
            contentManager.saveContent((IMemento)this.container.proxy(), pairsCollection, this.opRunner);
            PersistenceFrameworkTest.fail((String)"Load provider with same loading type exists. ");
        }
        catch (MementoContentManagerException cme) {
            String errorMessage = cme.getMessage();
            PersistenceFrameworkTest.assertFalse((boolean)"storeProviderObjectType1".equals("storeProviderObjectType2"));
            PersistenceFrameworkTest.assertTrue((boolean)errorMessage.contains("storeProviderObjectType1"));
            PersistenceFrameworkTest.assertTrue((boolean)errorMessage.contains("storeProviderObjectType2"));
        }
    }

    private Object appendToCollection(Collection<Object> collection, Object item) {
        collection.add(item);
        return item;
    }
}

