/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.property.list.SelfListProperty;
import org.eclipse.core.internal.databinding.property.map.SelfMapProperty;
import org.eclipse.core.internal.databinding.property.set.SelfSetProperty;
import org.eclipse.core.internal.databinding.property.value.ObservableValueProperty;
import org.eclipse.core.internal.databinding.property.value.SelfValueProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties {
    public static <S, E> IObservableMap<?, ?>[] observeEach(IObservableSet<E> domainSet, IValueProperty<? super E, ?>[] properties) {
        IObservableMap[] maps = new IObservableMap[properties.length];
        int i = 0;
        while (i < maps.length) {
            maps[i] = properties[i].observeDetail(domainSet);
            ++i;
        }
        return maps;
    }

    public static <S, E> List<IObservableMap<E, ? extends S>> observeEach(IObservableSet<E> domainSet, List<IValueProperty<? super E, ? extends S>> properties) {
        ArrayList<IObservableMap<IObservableMap<E, ? extends S>, S>> maps = new ArrayList<IObservableMap<IObservableMap<E, ? extends S>, S>>(properties.size());
        for (IValueProperty<E, S> property : properties) {
            maps.add(property.observeDetail(domainSet));
        }
        return maps;
    }

    public static <S, E> IObservableMap<?, ?>[] observeEach(IObservableMap<?, E> domainMap, IValueProperty<? super E, ?>[] properties) {
        IObservableMap[] maps = new IObservableMap[properties.length];
        int i = 0;
        while (i < maps.length) {
            maps[i] = properties[i].observeDetail(domainMap);
            ++i;
        }
        return maps;
    }

    public static <K, V> List<IObservableMap<K, ?>> observeEach(IObservableMap<K, V> domainMap, List<IValueProperty<? super V, ?>> properties) {
        ArrayList maps = new ArrayList(properties.size());
        for (IValueProperty<V, ?> property : properties) {
            maps.add(property.observeDetail(domainMap));
        }
        return maps;
    }

    public static <T> IValueProperty<T, T> selfValue(Object valueType) {
        return new SelfValueProperty(valueType);
    }

    public static <T> IValueProperty<T, T> selfValue(Class<T> valueType) {
        return new SelfValueProperty<T>(valueType);
    }

    public static <E> IListProperty<List<E>, E> selfList(Object elementType) {
        return new SelfListProperty(elementType);
    }

    public static <E> IListProperty<List<E>, E> selfList(Class<E> elementType) {
        return new SelfListProperty<E>(elementType);
    }

    public static <E> ISetProperty<Set<E>, E> selfSet(Object elementType) {
        return new SelfSetProperty(elementType);
    }

    public static <E> ISetProperty<Set<E>, E> selfSet(Class<E> elementType) {
        return new SelfSetProperty<E>(elementType);
    }

    public static <K, V> IMapProperty<Map<K, V>, K, V> selfMap(Object keyType, Object valueType) {
        return new SelfMapProperty(keyType, valueType);
    }

    public static <T> IValueProperty<IObservableValue<T>, T> observableValue(Object valueType) {
        return new ObservableValueProperty(valueType);
    }

    public static <T> IValueProperty<IObservableValue<T>, T> observableValue(Class<T> valueType) {
        return new ObservableValueProperty<T>(valueType);
    }
}

