/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.platform.discovery.util.internal.ContractChecker;

public final class StatusUtils {
    private StatusUtils() {
    }

    public static void applyToStatusLine(IStatus status, WizardPage wizardPage) {
        ContractChecker.nullCheckParam(status, "status");
        ContractChecker.nullCheckParam(wizardPage, "wizardPage");
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                wizardPage.setMessage(message, 0);
                wizardPage.setPageComplete(true);
                wizardPage.setErrorMessage(null);
                break;
            }
            case 2: {
                wizardPage.setMessage(message, 2);
                wizardPage.setPageComplete(true);
                wizardPage.setErrorMessage(null);
                break;
            }
            case 1: {
                wizardPage.setMessage(message, 1);
                wizardPage.setPageComplete(false);
                wizardPage.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                wizardPage.setMessage(null);
                wizardPage.setErrorMessage(message);
                wizardPage.setPageComplete(false);
            }
        }
    }

    public static IStatus getMostSevere(IStatus[] status) {
        IStatus max = null;
        int i = 0;
        while (i < status.length) {
            IStatus curr = status[i];
            if (curr.matches(4)) {
                return curr;
            }
            if (max == null || curr.getSeverity() > max.getSeverity()) {
                max = curr;
            }
            ++i;
        }
        return max;
    }

    public static IStatus statusCancel(String message) {
        return StatusUtils.createStatus(8, message);
    }

    public static IStatus statusError(String message) {
        return StatusUtils.createStatus(4, message);
    }

    public static IStatus statusError(String message, Throwable ex) {
        return StatusUtils.createStatus(4, message, ex);
    }

    public static IStatus statusWarning(String message) {
        return StatusUtils.createStatus(2, message);
    }

    public static IStatus statusWarning(String message, Throwable ex) {
        return StatusUtils.createStatus(2, message, ex);
    }

    public static IStatus statusInfo(String message) {
        return StatusUtils.createStatus(1, message);
    }

    public static IStatus statusInfo(String message, Throwable cause) {
        return StatusUtils.createStatus(1, message, cause);
    }

    public static IStatus statusOk(String message) {
        return StatusUtils.createStatus(0, message);
    }

    private static IStatus createStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.platform.discovery.util", 0, message, null);
    }

    private static IStatus createStatus(int severity, String message, Throwable ex) {
        return new Status(severity, "org.eclipse.platform.discovery.util", 0, message, ex);
    }

    public static MultiStatus createMultiStatus(String message) {
        return new MultiStatus("org.eclipse.platform.discovery.util", 0, message, null);
    }
}

