/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.destprefs.internal.xpparser;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.destprefs.api.ISearchDestinationConfigurator;
import org.eclipse.platform.discovery.destprefs.internal.xpparser.ISearchDestinationsConfiguratorDescription;
import org.eclipse.platform.discovery.destprefs.internal.xpparser.ISearchDestinationsConfiguratorXPParser;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.SearchProviderConfigurationFactory;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;

public class SearchDestinationsConfiguratorXPParser
extends AbstractExtensionPointParser<ISearchDestinationsConfiguratorDescription>
implements ISearchDestinationsConfiguratorXPParser {
    public static final String XP_ID = "org.eclipse.platform.discovery.destprefs.configurator";
    public static final String CONFIGURATOR_ELEMENT_NAME = "destinationConfigurator";
    public static final String CONFIGURATOR_ID_ELEMENT_NAME = "id";
    public static final String CONFIGURATOR_DEST_PROVIDER_ID_ELEMENT_NAME = "destProviderId";
    public static final String CONFIGURATOR_FQNAME_ELEMENT_NAME = "contributorClass";

    public SearchDestinationsConfiguratorXPParser(IExtensionRegistry extRegistry) {
        super(extRegistry, XP_ID, CONFIGURATOR_ELEMENT_NAME);
    }

    protected ISearchDestinationsConfiguratorDescription createObject(final IConfigurationElement element) throws CoreException {
        final String destProviderId = element.getAttribute(CONFIGURATOR_DEST_PROVIDER_ID_ELEMENT_NAME);
        final String destCategoryId = this.destinationCategoryIdFor(destProviderId);
        return new ISearchDestinationsConfiguratorDescription(){

            @Override
            public String destinationProviderId() {
                return destProviderId;
            }

            @Override
            public String destinationCategoryId() {
                return destCategoryId;
            }

            public ISearchDestinationConfigurator<?> createConfigurator() {
                try {
                    return (ISearchDestinationConfigurator)element.createExecutableExtension(SearchDestinationsConfiguratorXPParser.CONFIGURATOR_FQNAME_ELEMENT_NAME);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private String destinationCategoryIdFor(String destProviderId) {
        List destinationCategories = this.searchProviderConfiguration().getDestinationCategories();
        for (IDestinationCategoryDescription destCategory : destinationCategories) {
            IDestinationsProviderDescription provider = this.getDestinationProvider(destCategory, destProviderId);
            if (provider == null) continue;
            return destCategory.getId();
        }
        throw new IllegalArgumentException("Could not find destination category for destination provider " + destProviderId);
    }

    private IDestinationsProviderDescription getDestinationProvider(IDestinationCategoryDescription destCategory, String destProviderId) {
        for (IDestinationsProviderDescription destProvider : this.searchProviderConfiguration().getDestinationProvidersForCategory(destCategory)) {
            if (!destProviderId.equals(destProvider.getId())) continue;
            return destProvider;
        }
        return null;
    }

    protected ISearchProviderConfiguration searchProviderConfiguration() {
        return new SearchProviderConfigurationFactory().getSearchProviderConfiguration(this.extRegistry);
    }
}

