/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.destprefs.internal.prefpage.ui;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.platform.discovery.destprefs.api.ISearchDestinationConfigurator;
import org.eclipse.platform.discovery.destprefs.api.ISearchDestinationTester;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.CategoryDestinationProviderPair;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.DestinationConfiguratorSelection;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.IDestinationConfiguratorsPresenter;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.IDestinationConfiguratorsView;
import org.eclipse.platform.discovery.destprefs.internal.xpparser.ISearchDestinationsConfiguratorDescription;
import org.eclipse.platform.discovery.destprefs.internal.xpparser.SearchDestinationsConfiguratorXPParser;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.eclipse.platform.discovery.util.internal.ContractChecker;

public class DestinationConfiguratorsPresenter
implements IDestinationConfiguratorsPresenter {
    private final SearchDestinationsConfiguratorXPParser configuratorParser;
    private IDestinationConfiguratorsView view;
    private final ISearchProviderConfiguration searchConfig;
    private ISearchDestination destination;
    private String destinationProviderId;

    public DestinationConfiguratorsPresenter(SearchDestinationsConfiguratorXPParser configuratorParser, ISearchProviderConfiguration searchConfig) {
        this.configuratorParser = configuratorParser;
        this.searchConfig = searchConfig;
    }

    @Override
    public void setView(IDestinationConfiguratorsView view) {
        ContractChecker.nullCheckParam((Object)view);
        this.view = view;
        view.setInput(this.buildInput());
    }

    private Collection<CategoryDestinationProviderPair> buildInput() {
        ArrayList<CategoryDestinationProviderPair> result = new ArrayList<CategoryDestinationProviderPair>();
        for (ISearchDestinationsConfiguratorDescription desc : this.configuratorParser.readContributions()) {
            IDestinationCategoryDescription category = this.findCategory(desc.destinationCategoryId());
            IDestinationsProviderDescription destinationProvider = this.findProvider(desc.destinationProviderId(), category);
            result.add(new CategoryDestinationProviderPair(category, destinationProvider));
        }
        return result;
    }

    private IDestinationsProviderDescription findProvider(String destinationProviderId, IDestinationCategoryDescription category) {
        for (IDestinationsProviderDescription provider : this.searchConfig.getDestinationProvidersForCategory(category)) {
            if (!provider.getId().equals(destinationProviderId)) continue;
            return provider;
        }
        throw new RuntimeException("cannot find dest provider:" + destinationProviderId);
    }

    private IDestinationCategoryDescription findCategory(String destinationCategoryId) {
        for (IDestinationCategoryDescription category : this.searchConfig.getDestinationCategories()) {
            if (!category.getId().equals(destinationCategoryId)) continue;
            return category;
        }
        throw new RuntimeException("cannot find dest category:" + destinationCategoryId);
    }

    @Override
    public void selectionChanged(DestinationConfiguratorSelection selection) {
        this.destination = selection.destination;
        this.destinationProviderId = selection.destProviderId;
        if (this.destination != null) {
            ContractChecker.nullCheckField((Object)this.destinationProviderId, (String)"destinationProviderId");
        }
        this.view.setAddEnabled(this.destinationProviderId != null);
        if (this.destination == null) {
            this.view.setEditEnabled(false);
            this.view.setRemoveEnabled(false);
            this.view.setTestEnabled(false);
        } else {
            this.view.setEditEnabled(true);
            this.view.setRemoveEnabled(true);
            this.view.setTestEnabled(this.getConfigDescription(this.destinationProviderId).createConfigurator().getSearchDestinationTester() != null);
        }
    }

    @Override
    public void addDestination() {
        ContractChecker.nullCheckField((Object)this.destinationProviderId, (String)"destinationProviderId");
        ISearchDestinationConfigurator configurator = this.getConfigDescription(this.destinationProviderId).createConfigurator();
        IStatus result = configurator.createDestination(this.view.getShell());
        this.updateView(result);
    }

    private void updateView(IStatus result) {
        this.view.setStatus(result);
        if (result.isOK()) {
            this.view.setInput(this.buildInput());
        }
    }

    private ISearchDestinationsConfiguratorDescription getConfigDescription(String destinationProviderId) {
        for (ISearchDestinationsConfiguratorDescription desc : this.configuratorParser.readContributions()) {
            if (!desc.destinationProviderId().equals(destinationProviderId)) continue;
            return desc;
        }
        throw new RuntimeException("cannot find destination configurator for dest provider id:" + destinationProviderId);
    }

    @Override
    public <T extends ISearchDestination> void editDestination() {
        ContractChecker.nullCheckField((Object)this.destinationProviderId, (String)"destinationProviderId");
        ContractChecker.nullCheckField((Object)this.destination, (String)"destination");
        ISearchDestinationConfigurator<ISearchDestination> configurator = this.getConfigDescription(this.destinationProviderId).createConfigurator();
        IStatus result = configurator.editDestination(this.view.getShell(), this.destination);
        this.updateView(result);
    }

    @Override
    public <T extends ISearchDestination> void removeDestination() {
        ContractChecker.nullCheckField((Object)this.destinationProviderId, (String)"destinationProviderId");
        ContractChecker.nullCheckField((Object)this.destination, (String)"destination");
        ISearchDestinationConfigurator<ISearchDestination> configurator = this.getConfigDescription(this.destinationProviderId).createConfigurator();
        IStatus result = configurator.deleteDestination(this.view.getShell(), this.destination);
        this.updateView(result);
    }

    @Override
    public <T extends ISearchDestination> void testDestination() {
        ContractChecker.nullCheckField((Object)this.destinationProviderId, (String)"destinationProviderId");
        ContractChecker.nullCheckField((Object)this.destination, (String)"destination");
        ISearchDestinationTester<ISearchDestination> tester = this.getConfigDescription(this.destinationProviderId).createConfigurator().getSearchDestinationTester();
        IStatus result = tester.test(this.view.getShell(), this.destination);
        this.view.setStatus(result);
    }
}

