/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.internal.resources.semantic.ui.Messages;
import org.eclipse.core.internal.resources.semantic.ui.SemanticResourcesUIPlugin;
import org.eclipse.core.internal.resources.semantic.ui.wizard.AddUrlResourceNameAndURLPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AddUrlResourceCheckURLPage
extends WizardPage {
    Text urlText;
    Button ignoreCheckResults;
    Button retrieveContent;
    String url;

    public AddUrlResourceCheckURLPage() {
        super(AddUrlResourceNameAndURLPage.class.getName());
        this.setTitle(Messages.AddUrlResourceCheckURLPage_PageTitle_XGRP);
    }

    public boolean shouldRetrieveContent() {
        return this.retrieveContent.getSelection();
    }

    public void setUrl(String newUrl) {
        this.setPageComplete(false);
        this.url = newUrl;
        if (this.urlText != null) {
            if (this.url == null) {
                this.urlText.setText("");
            } else {
                this.urlText.setText(this.url);
            }
        }
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        new Label(main, 0).setText(Messages.AddUrlResourceCheckURLPage_Url_XFLD);
        this.urlText = new Text(main, 2048);
        this.urlText.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.urlText);
        if (this.url != null) {
            this.urlText.setText(this.url);
        }
        this.ignoreCheckResults = new Button(main, 32);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.ignoreCheckResults);
        this.ignoreCheckResults.setText(Messages.AddUrlResourceCheckURLPage_IgnoreChecks_XBUT);
        this.ignoreCheckResults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddUrlResourceCheckURLPage.this.checkPage();
            }
        });
        this.retrieveContent = new Button(main, 32);
        this.retrieveContent.setSelection(true);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.retrieveContent);
        this.retrieveContent.setText(Messages.AddUrlResourceCheckURLPage_Retrieve_XBUT);
        this.setPageComplete(false);
        this.setControl((Control)main);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.checkPage();
        }
    }

    void checkPage() {
        boolean errorFound;
        block19: {
            boolean errorFound2;
            URL urlObject;
            URI uri;
            block18: {
                boolean errorFound3;
                this.setErrorMessage(null);
                this.setMessage(null, 2);
                try {
                    if (this.url != null) break block18;
                    this.setErrorMessage(Messages.AddUrlResourceCheckURLPage_URLMissing_XMSG);
                }
                catch (Throwable throwable) {
                    boolean errorFound4;
                    boolean bl = errorFound4 = this.getErrorMessage() != null;
                    if (!errorFound4 && this.ignoreCheckResults.getSelection()) {
                        this.setMessage(Messages.AddUrlResourceCheckURLPage_IgnoringResult_XMSG, 2);
                    }
                    this.setPageComplete(this.getErrorMessage() == null);
                    throw throwable;
                }
                boolean bl = errorFound3 = this.getErrorMessage() != null;
                if (!errorFound3 && this.ignoreCheckResults.getSelection()) {
                    this.setMessage(Messages.AddUrlResourceCheckURLPage_IgnoringResult_XMSG, 2);
                }
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            try {
                uri = new URI(this.url);
            }
            catch (URISyntaxException uRISyntaxException) {
                boolean errorFound5;
                this.setErrorMessage(NLS.bind((String)Messages.AddUrlResourceCheckURLPage_InavlidSyntax_XMSG, (Object)this.url));
                boolean bl = errorFound5 = this.getErrorMessage() != null;
                if (!errorFound5 && this.ignoreCheckResults.getSelection()) {
                    this.setMessage(Messages.AddUrlResourceCheckURLPage_IgnoringResult_XMSG, 2);
                }
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            try {
                urlObject = uri.toURL();
            }
            catch (Exception e1) {
                boolean errorFound6;
                this.setErrorMessage(NLS.bind((String)Messages.AddUrlResourceCheckURLPage_InvalidUrlWithMessage_XMSG, (Object)this.url, (Object)e1.getMessage()));
                boolean bl = errorFound6 = this.getErrorMessage() != null;
                if (!errorFound6 && this.ignoreCheckResults.getSelection()) {
                    this.setMessage(Messages.AddUrlResourceCheckURLPage_IgnoringResult_XMSG, 2);
                }
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            if (this.ignoreCheckResults.getSelection()) break block19;
            final Exception[] exception = new Exception[1];
            try {
                this.getWizard().getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            urlObject.openConnection().connect();
                        }
                        catch (Exception e) {
                            exception[0] = e;
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                SemanticResourcesUIPlugin.handleError(e.getMessage(), e, true);
            }
            catch (InterruptedException e) {
                SemanticResourcesUIPlugin.handleError(e.getMessage(), e, true);
            }
            if (exception[0] == null) break block19;
            this.setErrorMessage(NLS.bind((String)Messages.AddUrlResourceCheckURLPage_ConnectFailed_XMSG, (Object)this.url, (Object)exception[0].getMessage()));
            boolean bl = errorFound2 = this.getErrorMessage() != null;
            if (!errorFound2 && this.ignoreCheckResults.getSelection()) {
                this.setMessage(Messages.AddUrlResourceCheckURLPage_IgnoringResult_XMSG, 2);
            }
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        boolean bl = errorFound = this.getErrorMessage() != null;
        if (!errorFound && this.ignoreCheckResults.getSelection()) {
            this.setMessage(Messages.AddUrlResourceCheckURLPage_IgnoringResult_XMSG, 2);
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }
}

