/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.internal.resources.semantic.ui.actions.ActionBase;
import org.eclipse.core.internal.resources.semantic.ui.actions.Messages;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;

public class RevertAction
extends ActionBase {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(this.checkFilesWithReadOnlyFlagOnly(false) && this.checkSelectionNonLocalOnly());
    }

    public void run(IAction action) {
        IRunnableWithProgress outerRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor outerMonitor) throws InvocationTargetException, InterruptedException {
                for (final ISemanticFile file : RevertAction.this.getSelection()) {
                    outerMonitor.subTask(NLS.bind((String)Messages.RevertAction_Reverting_XMSG, (Object)file.getAdaptedResource().getName()));
                    if (outerMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    IWorkspaceRunnable myRunnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            file.revertChanges(0, monitor);
                        }
                    };
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    try {
                        workspace.run(myRunnable, workspace.getRuleFactory().refreshRule(file.getAdaptedResource()), 0, null);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e, NLS.bind((String)Messages.RevertAction_RevertFailed_XMSG, (Object)file.getAdaptedFile().getFullPath().toString()));
                    }
                }
            }
        };
        this.run(outerRunnable);
    }
}

