/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.remote;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.semantic.examples.remote.Messages;
import org.eclipse.core.resources.semantic.examples.remote.RemoteItem;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStoreEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteItemSelectionDialog
extends Dialog {
    private TableViewer tv;
    private final RemoteItem[] itemsToSelect;
    private List<RemoteItem> selected = new ArrayList<RemoteItem>();
    private final boolean multiSelect;

    public RemoteItemSelectionDialog(Shell parentShell, RemoteItem[] items, boolean multiSelect) {
        super(parentShell);
        this.itemsToSelect = items;
        this.multiSelect = multiSelect;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.multiSelect) {
            newShell.setText(Messages.RemoteItemSelectionDialog_SelectItems_XGRP);
        } else {
            newShell.setText(Messages.RemoteItemSelectionDialog_SelectItem_XGRP);
        }
    }

    public List<RemoteItem> getSelectedItems() {
        return this.selected;
    }

    protected Control createDialogArea(Composite parent) {
        Composite myArea = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)myArea);
        myArea.setLayout((Layout)new GridLayout(1, false));
        this.tv = this.multiSelect ? new TableViewer(myArea) : new TableViewer(myArea, 4);
        Table table = this.tv.getTable();
        TableColumn c1 = new TableColumn(table, 0);
        c1.setText(Messages.RemoteItemSelectionDialog_Name_XFLD);
        c1.setWidth(200);
        this.tv.setContentProvider((IContentProvider)new ContentProvider(this.itemsToSelect));
        this.tv.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.tv.setInput(new Object());
        return myArea;
    }

    protected void okPressed() {
        IStructuredSelection sel = (IStructuredSelection)this.tv.getSelection();
        this.selected.clear();
        this.selected.addAll(sel.toList());
        super.okPressed();
    }

    private static final class ContentProvider
    implements ITreeContentProvider {
        private RemoteItem[] myContent;

        ContentProvider(RemoteItem[] content) {
            this.myContent = content;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.myContent;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static final class LabelProvider
    implements ITableLabelProvider {
        LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (((RemoteItem)element).getType() == RemoteItem.Type.FOLDER) {
                        return RemoteStoreEditor.FOLDERIMAGE;
                    }
                    return RemoteStoreEditor.FILEIMAGE;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((RemoteItem)element).getName();
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

