/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.semantic.examples.Messages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectScenarioPage
extends WizardPage {
    Set<Scenario> scenarios = new HashSet<Scenario>();

    public SelectScenarioPage() {
        super(SelectScenarioPage.class.getName());
        this.setTitle(Messages.CreateDemoProjectPage_CreateProject_XGRP);
        Scenario[] scenarioArray = Scenario.values();
        int n = scenarioArray.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario sc = scenarioArray[n2];
            this.scenarios.add(sc);
            ++n2;
        }
    }

    public void createControl(Composite parent) {
        this.setMessage(Messages.SelectScenarioPage_SelectScenarios_XMSG);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        Composite main = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        main.setLayout((Layout)new GridLayout(1, false));
        Scenario[] scenarioArray = Scenario.values();
        int n = scenarioArray.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario scenario = scenarioArray[n2];
            this.addButton(main, scenario);
            ++n2;
        }
        this.check();
        this.setControl((Control)main);
    }

    public Set<Scenario> getScenarios() {
        return this.scenarios;
    }

    private void addButton(Composite main, final Scenario scenario) {
        final Button but = new Button(main, 32);
        but.setText(scenario.getDescription());
        but.setSelection(this.scenarios.contains((Object)scenario));
        but.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (but.getSelection()) {
                    SelectScenarioPage.this.scenarios.add(scenario);
                } else {
                    SelectScenarioPage.this.scenarios.remove((Object)scenario);
                }
                SelectScenarioPage.this.check();
            }
        });
    }

    protected void check() {
        this.setPageComplete(!this.scenarios.isEmpty());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Scenario {
        DEFAULTCONTENTPROVIDER("DefaultContentProvider", Messages.SelectScenarioPage_DefaultProviderScenario_XFLD),
        WEBSERVICECONTENTPROVIDER("SampleWSDLXSDContentProvider", Messages.SelectScenarioPage_WebServiceScenario_XFLD),
        COMPOSITECONTENTPROVIDER("SampleCompositeResourceContentProvider", Messages.SelectScenarioPage_CompositeProvider_XFLD),
        REMOTESTORECONTENTPROVIDER("RemoteStoreContentProvider", Messages.SelectScenarioPage_RemoteStoreScenario_XFLD);

        private final String folderName;
        private final String description;

        private Scenario(String folderName, String description) {
            this.folderName = folderName;
            this.description = description;
        }

        public String getFolderName() {
            return this.folderName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

