/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticProject;
import org.eclipse.core.resources.semantic.examples.CreateDemoProjectPage;
import org.eclipse.core.resources.semantic.examples.Messages;
import org.eclipse.core.resources.semantic.examples.SelectScenarioPage;
import org.eclipse.core.resources.semantic.examples.SemanticResourcesPluginExamples;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFolder;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStore;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewDemoSemanticProjectWizard
extends Wizard
implements INewWizard {
    public static final QualifiedName TEMP_DIR_NAME = new QualifiedName("org.eclipse.core.resources.semantic.examples", "TemporaryDirectory");
    static final String DEFAULT_PROJECT_NAME = "SemanticFileSystemDemo";

    public void addPages() {
        this.setWindowTitle(Messages.CreateDemoProjectPage_CreateProject_XGRP);
        this.addPage((IWizardPage)new SelectScenarioPage());
        this.addPage((IWizardPage)new CreateDemoProjectPage());
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof SelectScenarioPage) {
            SelectScenarioPage prev = (SelectScenarioPage)this.getPage(SelectScenarioPage.class.getName());
            CreateDemoProjectPage next = (CreateDemoProjectPage)this.getPage(CreateDemoProjectPage.class.getName());
            next.setScenarios(prev.getScenarios());
            return next;
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        SelectScenarioPage scenPage = (SelectScenarioPage)this.getPage(SelectScenarioPage.class.getName());
        CreateDemoProjectPage projPage = (CreateDemoProjectPage)this.getPage(CreateDemoProjectPage.class.getName());
        final Set<SelectScenarioPage.Scenario> scenarios = scenPage.getScenarios();
        final String projectName = projPage.getProjectName();
        final String directoryName = projPage.getDirectoryName();
        IWorkspaceRunnable myRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProject project = workspace.getRoot().getProject(projectName);
                if (!project.exists()) {
                    IProjectDescription description = workspace.newProjectDescription(projectName);
                    try {
                        description.setLocationURI(new URI("semanticfs", null, "/" + projectName, null));
                        description.setNatureIds(new String[]{"org.eclipse.core.resources.semantic.examples.nature"});
                    }
                    catch (URISyntaxException e) {
                        Status status = new Status(4, "org.eclipse.core.resources.semantic.examples", e.getMessage(), (Throwable)e);
                        SemanticResourcesPluginExamples.getDefault().getLog().log((IStatus)status);
                    }
                    project.create(description, null);
                }
                if (!project.isOpen()) {
                    project.open(monitor);
                    RepositoryProvider.map((IProject)project, (String)"org.eclipse.core.internal.resources.semantic.DelegatingRepositoryProvider");
                }
                for (SelectScenarioPage.Scenario scenario : scenarios) {
                    project.getFolder(scenario.getFolderName()).create(false, true, monitor);
                }
                File tempFolder = new File(directoryName);
                if (!tempFolder.exists()) {
                    tempFolder.mkdirs();
                }
                NewDemoSemanticProjectWizard.this.copyMimes(monitor, tempFolder);
                ISemanticProject sproject = (ISemanticProject)project.getAdapter(ISemanticProject.class);
                sproject.setPersistentProperty(TEMP_DIR_NAME, directoryName);
                if (scenarios.contains((Object)SelectScenarioPage.Scenario.REMOTESTORECONTENTPROVIDER)) {
                    byte[] contents;
                    RemoteStore store = (RemoteStore)project.getAdapter(RemoteStore.class);
                    RemoteFolder first = store.getRootFolder().addFolder("First");
                    try {
                        contents = "Hello, world".getBytes(store.getDefaultCharset());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        contents = "Hello, world".getBytes();
                    }
                    store.getRootFolder().addFile("File1", contents, System.currentTimeMillis());
                    RemoteFolder second = first.addFolder("Second");
                    second.addFile("File1", contents, System.currentTimeMillis());
                    store.serialize(monitor);
                }
                project.refreshLocal(2, monitor);
            }
        };
        try {
            workspace.run(myRunnable, (ISchedulingRule)workspace.getRoot(), 1, null);
        }
        catch (CoreException e) {
            SemanticResourcesPluginExamples.getDefault().getLog().log(e.getStatus());
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    void copyMimes(IProgressMonitor monitor, File tempFolder) throws CoreException {
        File mimesFolder = new File(String.valueOf(tempFolder.getPath()) + "/mimes");
        mimesFolder.mkdir();
        File compositeFolder = new File(String.valueOf(tempFolder.getPath()) + "/composites");
        compositeFolder.mkdir();
        this.copyMime(mimesFolder, "/mimes/wsdl+xsd/address.xsd", "address.xsd", monitor);
        this.copyMime(mimesFolder, "/mimes/wsdl+xsd/customer.xsd", "customer.xsd", monitor);
        this.copyMime(mimesFolder, "/mimes/wsdl+xsd/PurchaseOrder.wsdl", "PurchaseOrder.wsdl", monitor);
        this.copyMime(mimesFolder, "/mimes/wsdl+xsd/SalesOrder.wsdl", "SalesOrder.wsdl", monitor);
        this.copyMime(compositeFolder, "/mimes/composite/aaa.txt", "aaa.txt", monitor);
        this.copyMime(compositeFolder, "/mimes/composite/test.txt", "test.txt", monitor);
        this.copyMime(compositeFolder, "/mimes/composite/test_en.txt", "test_en.txt", monitor);
        this.copyMime(compositeFolder, "/mimes/composite/test_en_US.txt", "test_en_US.txt", monitor);
        this.copyMime(compositeFolder, "/mimes/composite/test2.txt", "test2.txt", monitor);
    }

    private void copyMime(File mimesFolder, String source, String target, IProgressMonitor monitor) throws CoreException {
        InputStream is = ((Object)((Object)SemanticResourcesPluginExamples.getDefault())).getClass().getResourceAsStream(source);
        File newFile = new File(String.valueOf(mimesFolder.getPath()) + "/" + target);
        try {
            newFile.createNewFile();
            Util.transferStreams((InputStream)is, (OutputStream)new FileOutputStream(newFile), (IProgressMonitor)monitor);
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.examples", e.getMessage()));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.examples", e.getMessage()));
        }
    }
}

