/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.examples.AddFileOrFolderFromRemotePage;
import org.eclipse.core.resources.semantic.examples.HandlerUtilities;
import org.eclipse.core.resources.semantic.examples.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class HandleAddFileFromRemote
extends HandlerUtilities {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISemanticFolder sFolder = (ISemanticFolder)this.getSelectedObject(event, ISemanticFolder.class, true);
        if (sFolder == null) {
            this.showPopup(Messages.HandleAddFromRemote_Error_XGRP, Messages.HandleAddFromRemote_NotSemantic_XMSG);
            return null;
        }
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)new MyWizard(sFolder));
        dialog.open();
        return null;
    }

    void doIt(final ISemanticFolder parentFolder, final AddFileOrFolderFromRemotePage page) throws InterruptedException, InvocationTargetException {
        this.submit(Display.getCurrent().getActiveShell(), new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor actMonitor) throws CoreException {
                        boolean folderMode = page.isFolderMode();
                        String childName = page.getChildName();
                        File rootFile = new File(page.getPath());
                        URI uri = rootFile.toURI();
                        int childCount = folderMode && page.isDeep() ? this.countChildren(0, rootFile.listFiles()) : 1;
                        actMonitor.beginTask("", childCount * 2);
                        actMonitor.setTaskName(String.valueOf(Messages.HandleAddFileFromRemote_Adding_XMSG) + uri.toString());
                        if (folderMode) {
                            ISemanticFolder folder = parentFolder.addFolder(childName, uri, 2, actMonitor);
                            if (page.isDeep()) {
                                this.addChildren(0, folder, rootFile.listFiles(), actMonitor);
                            } else {
                                actMonitor.worked(1);
                            }
                        } else {
                            parentFolder.addFile(childName, uri, 2, actMonitor);
                            actMonitor.worked(1);
                        }
                        actMonitor.setTaskName(Messages.HandleAddFileFromRemote_Refreshing_XMSG);
                        parentFolder.getAdaptedContainer().refreshLocal(2, actMonitor);
                        actMonitor.done();
                    }

                    private int countChildren(int input, File[] children) {
                        int result = input;
                        result += children.length;
                        File[] fileArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File child = fileArray[n2];
                            if (child.isDirectory()) {
                                result = this.countChildren(result, child.listFiles());
                            }
                            ++n2;
                        }
                        return result;
                    }

                    private int addChildren(int actIndex, ISemanticFolder folder, File[] childFiles, IProgressMonitor actMonitor) throws CoreException {
                        int currentChildIndex = actIndex;
                        File[] fileArray = childFiles;
                        int n = childFiles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File childFile = fileArray[n2];
                            if (actMonitor.isCanceled()) {
                                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.examples", null, (Throwable)new InterruptedException()));
                            }
                            URI childUri = childFile.toURI();
                            actMonitor.setTaskName(NLS.bind((String)Messages.HandleAddFileFromRemote_AddingResource_XMSG, (Object)childUri.toString()));
                            ++currentChildIndex;
                            if (childFile.isDirectory()) {
                                ISemanticFolder childFolder = folder.addFolder(childFile.getName(), childUri, 2, actMonitor);
                                currentChildIndex = this.addChildren(currentChildIndex, childFolder, childFile.listFiles(), actMonitor);
                            } else {
                                folder.addFile(childFile.getName(), childUri, 2, actMonitor);
                            }
                            actMonitor.worked(1);
                            ++n2;
                        }
                        return currentChildIndex;
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(runnable, monitor);
                }
                catch (CoreException e) {
                    if (e.getCause() instanceof InterruptedException) {
                        throw (InterruptedException)e.getCause();
                    }
                    throw new InvocationTargetException(e);
                }
            }
        });
    }

    private final class MyWizard
    extends Wizard {
        private final ISemanticFolder myFolder;

        public MyWizard(ISemanticFolder folder) {
            this.myFolder = folder;
            this.addPage((IWizardPage)new AddFileOrFolderFromRemotePage(this.myFolder));
            this.setWindowTitle(Messages.HandleAddFileFromRemote_AddLocalResource_XGRP);
        }

        public boolean performFinish() {
            AddFileOrFolderFromRemotePage page = (AddFileOrFolderFromRemotePage)this.getPage(AddFileOrFolderFromRemotePage.PAGE_NAME);
            try {
                HandleAddFileFromRemote.this.doIt(this.myFolder, page);
            }
            catch (InterruptedException interruptedException) {
                page.setErrorMessage(Messages.HandleAddFileFromRemote_Interrupted_XMSG);
                return false;
            }
            catch (InvocationTargetException e) {
                page.setErrorMessage(e.getCause().getMessage());
                return false;
            }
            return true;
        }
    }
}

