/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.compatibility.internal.contributors.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.compatibility.internal.contributors.ContributionFailedException;
import org.eclipse.platform.discovery.compatibility.internal.contributors.IDynamicRegistryContributor;
import org.eclipse.platform.discovery.runtime.internal.xp.IContributionsReader;
import org.eclipse.platform.discovery.util.internal.StringInputStreamAdapter;
import org.eclipse.platform.discovery.util.internal.xml.IPluginXmlUtils;
import org.eclipse.platform.discovery.util.internal.xml.PluginXmlUtils;
import org.w3c.dom.Element;

public abstract class DynamicRegistryContributor<T>
implements IDynamicRegistryContributor {
    private static final boolean PERSIST = false;
    private final IContributionsReader<T> contributionsReader;
    private final String targetExtensionPointId;
    private final String targetElementName;

    public DynamicRegistryContributor(IContributionsReader<T> contributionsReader, String targetExtensionPointId, String targetElementName) {
        this.contributionsReader = contributionsReader;
        this.targetExtensionPointId = targetExtensionPointId;
        this.targetElementName = targetElementName;
    }

    @Override
    public void contribute(IExtensionRegistry registry, IContributor contributor, Object token) throws ContributionFailedException {
        ArrayList failedContributors = new ArrayList();
        for (Object data : this.contributionsReader.readContributions()) {
            Element plugin = this.xmlUtils().createPluginSnippet(this.targetExtensionPointId);
            this.configurePluginElement(data, plugin);
            boolean success = this.writeToRegistry(plugin, registry, contributor, token, this.getContributionDescription(data));
            if (success) continue;
            failedContributors.add(data);
        }
        if (!failedContributors.isEmpty()) {
            throw new ContributionFailedException(this.getFailureMessage(failedContributors));
        }
    }

    protected abstract String getFailureMessage(Collection<T> var1);

    protected abstract String getContributionDescription(T var1);

    private void configurePluginElement(T data, Element element) {
        Element targetElement = element.getOwnerDocument().createElement(this.targetElementName);
        this.configureTargetElement(targetElement, data);
        Element extension = (Element)element.getFirstChild();
        extension.appendChild(targetElement);
    }

    protected abstract void configureTargetElement(Element var1, T var2);

    private boolean writeToRegistry(Element plugin, IExtensionRegistry registry, IContributor contributor, Object token, String name) {
        String xml = this.xmlUtils().toXML(plugin);
        StringInputStreamAdapter inputStream = new StringInputStreamAdapter(xml);
        ResourceBundle translationBundle = null;
        return registry.addContribution((InputStream)inputStream, contributor, false, name, translationBundle, token);
    }

    private IPluginXmlUtils xmlUtils() {
        return new PluginXmlUtils();
    }
}

