/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.vex.palette;

import java.util.List;
import org.eclipse.e4.xwt.vex.EditorMessages;
import org.eclipse.e4.xwt.vex.VEXEditor;
import org.eclipse.e4.xwt.vex.palette.CustomWidgetDrawer;
import org.eclipse.e4.xwt.vex.palette.EntryContentProvider;
import org.eclipse.e4.xwt.vex.palette.EntryLabelProvider;
import org.eclipse.e4.xwt.vex.palette.PaletteResourceManager;
import org.eclipse.e4.xwt.vex.palette.customize.CustomizeComponentFactory;
import org.eclipse.e4.xwt.vex.palette.customize.model.CustomizeComponent;
import org.eclipse.e4.xwt.vex.palette.part.ToolPaletteDrawer;
import org.eclipse.e4.xwt.vex.toolpalette.ContextType;
import org.eclipse.e4.xwt.vex.toolpalette.Entry;
import org.eclipse.e4.xwt.vex.toolpalette.ToolPaletteFactory;
import org.eclipse.e4.xwt.vex.util.ImageHelper;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;

public class PaletteRootFactory {
    private PaletteResourceManager trManager;

    public PaletteRootFactory(PaletteResourceManager trManager) {
        this.trManager = trManager;
    }

    public PaletteRoot createPaletteRoot() {
        PaletteRoot palette = new PaletteRoot();
        Resource resource = this.trManager.getResource();
        if (resource != null) {
            PaletteContainer createShapesDrawer = this.createShapesDrawer(resource);
            palette.addAll(createShapesDrawer.getChildren());
        }
        return palette;
    }

    private PaletteContainer createShapesDrawer(Resource resource) {
        PaletteDrawer componentsDrawer = this.createPaletteDrawer(EditorMessages.PaletteRootFactory_Shapes);
        if (this.trManager != null) {
            EntryContentProvider contentProvider = new EntryContentProvider();
            EntryLabelProvider labelProvider = new EntryLabelProvider();
            this.createToolPaletteStructure(componentsDrawer, contentProvider, labelProvider, resource);
        }
        CustomWidgetDrawer.addCustomWidgets(componentsDrawer);
        return componentsDrawer;
    }

    private PaletteDrawer createPaletteDrawer(String name) {
        ToolPaletteDrawer componentsDrawer = new ToolPaletteDrawer(name);
        componentsDrawer.setInitialState(1);
        return componentsDrawer;
    }

    private void createToolPaletteStructure(PaletteDrawer parentDrawer, EntryContentProvider contentProvider, EntryLabelProvider labelProvider, Object resource) {
        ImageDescriptor largeImage;
        Object[] children = contentProvider.getElements(resource);
        String name = labelProvider.getText(resource);
        if (name == null) {
            return;
        }
        String description = labelProvider.getDescription(resource);
        ImageDescriptor image = this.getImageDescriptor(resource);
        if (image == null) {
            image = labelProvider.getImageDescriptor(resource);
        }
        if ((largeImage = this.getLargeImageDescriptor(resource)) == null) {
            largeImage = labelProvider.getLargeImageDescriptor(resource);
        }
        if (children.length == 0) {
            CombinedTemplateCreationEntry component = new CombinedTemplateCreationEntry(name, description, resource, (CreationFactory)new SimpleFactory(resource.getClass()), image, largeImage);
            component.setDescription(description);
            parentDrawer.add((PaletteEntry)component);
        } else if (resource instanceof Entry) {
            PaletteDrawer componentsDrawer = this.createPaletteDrawer(name);
            componentsDrawer.setSmallIcon(image);
            componentsDrawer.setLargeIcon(largeImage);
            componentsDrawer.setDescription(description);
            parentDrawer.add((PaletteEntry)componentsDrawer);
            componentsDrawer.setParent((PaletteContainer)parentDrawer);
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.createToolPaletteStructure(componentsDrawer, contentProvider, labelProvider, child);
                ++n2;
            }
        } else {
            Object[] objectArray = children;
            int n = children.length;
            int n3 = 0;
            while (n3 < n) {
                Object child = objectArray[n3];
                this.createToolPaletteStructure(parentDrawer, contentProvider, labelProvider, child);
                ++n3;
            }
        }
    }

    private ImageDescriptor getImageDescriptor(Object source) {
        if (source instanceof Entry) {
            return ImageHelper.getImageDescriptor(this.trManager, ((Entry)source).getIcon());
        }
        return null;
    }

    private ImageDescriptor getLargeImageDescriptor(Object source) {
        if (source instanceof Entry) {
            return ImageHelper.getImageDescriptor(this.trManager, ((Entry)source).getLargeIcon());
        }
        return null;
    }

    public static PaletteRoot createPalette(IEditorPart editorPart) {
        PaletteRoot palette = new PaletteRoot();
        if (!(editorPart instanceof VEXEditor)) {
            return palette;
        }
        PaletteResourceManager trManager = (PaletteResourceManager)editorPart.getAdapter(PaletteResourceManager.class);
        PaletteRootFactory paletteFactory = new PaletteRootFactory(trManager);
        return paletteFactory.createPaletteRoot();
    }

    public static PaletteRoot createPaletteByResourceManager(PaletteResourceManager resourceManager) {
        PaletteRootFactory paletteFactory = new PaletteRootFactory(resourceManager);
        return paletteFactory.createPaletteRoot();
    }

    public static PaletteRoot createDynamicPalette(IEditorPart editorPart) {
        PaletteRoot palette = new PaletteRoot();
        if (!(editorPart instanceof VEXEditor)) {
            return palette;
        }
        PaletteResourceManager trManager = (PaletteResourceManager)editorPart.getAdapter(PaletteResourceManager.class);
        PaletteRootFactory paletteFactory = new PaletteRootFactory(trManager);
        return paletteFactory.createDynamicPaletteRoot();
    }

    public PaletteRoot createDynamicPaletteRoot() {
        PaletteRoot palette = new PaletteRoot();
        PaletteGroup dynamicGroup = new PaletteGroup(EditorMessages.VEXEditor_Dynamic);
        palette.add((PaletteEntry)dynamicGroup);
        return palette;
    }

    public static PaletteRoot createCustomizePalette(IEditorPart editorPart) {
        PaletteRoot palette = new PaletteRoot();
        if (!(editorPart instanceof VEXEditor)) {
            return palette;
        }
        PaletteResourceManager trManager = (PaletteResourceManager)editorPart.getAdapter(PaletteResourceManager.class);
        PaletteRootFactory paletteFactory = new PaletteRootFactory(trManager);
        return paletteFactory.createCustomizePaletteRoot();
    }

    public PaletteRoot createCustomizePaletteRoot() {
        PaletteRoot palette = new PaletteRoot();
        PaletteGroup customizeGroup = new PaletteGroup("Customize");
        Resource resource = this.trManager.getCustomizeResource();
        if (resource != null) {
            List<CustomizeComponent> result = CustomizeComponentFactory.loadCustomizeComponents();
            for (CustomizeComponent customizeComponent : result) {
                Entry customizeEntry = ToolPaletteFactory.eINSTANCE.createEntry();
                customizeEntry.setName(customizeComponent.getName());
                customizeEntry.setScope(customizeComponent.getScope());
                String iconString = customizeComponent.getIcon();
                if (iconString != null && iconString.length() > 0) {
                    customizeEntry.setIcon(iconString);
                }
                if ((iconString = customizeComponent.getLargeIcon()) != null && iconString.length() > 0) {
                    customizeEntry.setLargeIcon(iconString);
                }
                customizeEntry.setToolTip(customizeComponent.getTooptip());
                customizeEntry.setContent(customizeComponent.getContent());
                customizeEntry.setContext(ContextType.XML_TAG);
                CombinedTemplateCreationEntry component = new CombinedTemplateCreationEntry(customizeEntry.getName(), customizeEntry.getToolTip(), (Object)customizeEntry, (CreationFactory)new SimpleFactory(resource.getClass()), ImageHelper.getImageDescriptor(this.trManager, customizeEntry.getIcon()), ImageHelper.getImageDescriptor(this.trManager, customizeEntry.getLargeIcon()));
                customizeGroup.add((PaletteEntry)component);
            }
        }
        palette.add((PaletteEntry)customizeGroup);
        return palette;
    }
}

