/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.xwt.ui.utils.AbstractBuilder;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.bundle.BundlePluginModelBase;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.plugin.AbstractPluginModelBase;
import org.eclipse.pde.internal.core.plugin.PluginBase;
import org.eclipse.pde.internal.core.plugin.WorkspaceExtensionsModel;
import org.eclipse.pde.internal.core.text.plugin.PluginBaseNode;
import org.eclipse.pde.internal.core.text.plugin.PluginDocumentNodeFactory;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyBuilder
extends AbstractBuilder {
    private IPluginModelBase[] dependencies;
    private boolean[] optionals;

    public DependencyBuilder(IProject project, IPluginModelBase[] dependencies) {
        this(project, dependencies, null);
    }

    public DependencyBuilder(IProject project, IPluginModelBase[] dependencies, boolean[] optionals) {
        super(project);
        this.dependencies = dependencies;
        this.optionals = optionals;
        if (optionals == null) {
            this.optionals = new boolean[dependencies.length];
            int i = 0;
            while (i < this.optionals.length) {
                this.optionals[i] = false;
                ++i;
            }
        }
    }

    @Override
    public IStatus build() {
        if (this.dependencies == null || this.dependencies.length == 0) {
            return this.warning("No dependencies found");
        }
        return this.addDependencies(Arrays.asList(this.dependencies));
    }

    private boolean equals(IPluginModelBase source, IPluginModelBase target) {
        if (source == null) {
            return target == null;
        }
        if (target == null) {
            return false;
        }
        IPluginBase sourceBase = source.getPluginBase();
        String sourceId = sourceBase.getId();
        String sourceVersion = sourceBase.getVersion();
        if (sourceVersion != null) {
            sourceVersion = new Version(sourceVersion).toString();
        }
        IPluginBase targetBase = target.getPluginBase();
        String targetId = targetBase.getId();
        String targetVersion = targetBase.getVersion();
        if (targetVersion != null) {
            targetVersion = new Version(targetVersion).toString();
        }
        if (sourceVersion == null || targetVersion == null) {
            return sourceId.equals(targetId);
        }
        return sourceId.equals(targetId) && sourceVersion.equals(targetVersion);
    }

    private void filter(List<IPluginModelBase> pluginImports, IPluginImport pluginImport) {
        IPluginModelBase target = PluginRegistry.findModel((String)pluginImport.getId());
        Iterator<IPluginModelBase> iterator = pluginImports.iterator();
        while (iterator.hasNext()) {
            IPluginModelBase source = iterator.next();
            if (!this.equals(source, target)) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus addDependencies(List<IPluginModelBase> pluginImports) {
        try {
            WorkspaceBundleModel bundleModel;
            IPluginImport[] existedImports;
            this.refreshLocal();
            IBundlePluginModelBase model = (IBundlePluginModelBase)this.getModel();
            IPluginBase pluginBase = model.getPluginBase();
            IPluginImport[] iPluginImportArray = existedImports = pluginBase.getImports();
            int n = existedImports.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginImport dep = iPluginImportArray[n2];
                this.filter(pluginImports, dep);
                ++n2;
            }
            if (pluginImports.isEmpty()) {
                return this.warning("There's no dependency found.");
            }
            WorkspaceBundleModel workspaceBundleModel = bundleModel = (WorkspaceBundleModel)model.getBundleModel();
            synchronized (workspaceBundleModel) {
                ISharedExtensionsModel extensionsModel;
                bundleModel.load();
                boolean isBundleEditable = bundleModel.isEditable();
                if (!isBundleEditable) {
                    bundleModel.setEditable(true);
                }
                if ((extensionsModel = model.getExtensionsModel()) != null && extensionsModel instanceof WorkspaceExtensionsModel) {
                    ((WorkspaceExtensionsModel)extensionsModel).setEditable(true);
                }
                IPluginImport[] imports = new IPluginImport[pluginImports.size()];
                int i = 0;
                while (i < pluginImports.size()) {
                    IPluginModel candidate = (IPluginModel)pluginImports.get(i);
                    String pluginId = candidate.getPlugin().getId();
                    IPluginImport importNode = this.createImport(model.getPluginFactory(), pluginId);
                    importNode.setOptional(this.optionals[i]);
                    imports[i] = importNode;
                    ++i;
                }
                this.addImports(pluginBase, imports);
                bundleModel.save();
                if (!isBundleEditable) {
                    bundleModel.setEditable(false);
                }
                if (extensionsModel != null && extensionsModel instanceof WorkspaceExtensionsModel) {
                    ((WorkspaceExtensionsModel)extensionsModel).setEditable(false);
                }
            }
            this.buildClean();
        }
        catch (Exception e) {
            return this.error("Build dependency error: " + e.getMessage());
        }
        return Status.OK_STATUS;
    }

    private IPluginImport createImport(IPluginModelFactory factory, String id) {
        if (factory instanceof AbstractPluginModelBase) {
            return ((AbstractPluginModelBase)factory).createImport(id);
        }
        if (factory instanceof BundlePluginModelBase) {
            return ((BundlePluginModelBase)factory).createImport(id);
        }
        if (factory instanceof PluginDocumentNodeFactory) {
            return ((PluginDocumentNodeFactory)factory).createImport(id);
        }
        return null;
    }

    private void addImports(IPluginBase base, IPluginImport[] imports) throws Exception {
        if (base instanceof BundlePluginBase) {
            ((BundlePluginBase)base).add(imports);
        } else if (base instanceof PluginBase) {
            ((PluginBase)base).add(imports);
        } else if (base instanceof PluginBaseNode) {
            ((PluginBaseNode)base).add(imports);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatus unbuild() {
        if (this.dependencies == null || this.dependencies.length == 0) {
            return this.warning("No dependency found");
        }
        try {
            WorkspaceBundleModel bundleModel;
            IPluginImport[] existings;
            this.refreshLocal();
            IBundlePluginModelBase model = (IBundlePluginModelBase)this.getModel();
            IPluginBase pluginBase = model.getPluginBase();
            ArrayList<IPluginImport> removes = new ArrayList<IPluginImport>();
            IPluginImport[] iPluginImportArray = existings = pluginBase.getImports();
            int n = existings.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginImport pluginImport = iPluginImportArray[n2];
                IPluginModelBase importModel = PluginRegistry.findModel((String)pluginImport.getId());
                IPluginModelBase[] iPluginModelBaseArray = this.dependencies;
                int n3 = this.dependencies.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPluginModelBase dep = iPluginModelBaseArray[n4];
                    if (this.equals(importModel, dep)) {
                        removes.add(pluginImport);
                    }
                    ++n4;
                }
                ++n2;
            }
            if (removes.isEmpty()) {
                return this.warning("No dependency found for remove");
            }
            IBundle bundle = model.getBundleModel().getBundle();
            WorkspaceBundleModel workspaceBundleModel = bundleModel = (WorkspaceBundleModel)model.getBundleModel();
            synchronized (workspaceBundleModel) {
                bundleModel.load();
                bundleModel.setEditable(true);
                this.removeImports(pluginBase, removes.toArray(new IPluginImport[0]));
                this.removeDependencies(bundle, removes.toArray(new IPluginImport[0]));
                bundleModel.save();
                bundleModel.setEditable(false);
            }
            this.buildClean();
        }
        catch (Exception e) {
            return this.error("Build dependency error: " + e.getMessage());
        }
        return Status.OK_STATUS;
    }

    private void removeImports(IPluginBase base, IPluginImport[] imports) throws CoreException {
        if (base instanceof BundlePluginBase) {
            ((BundlePluginBase)base).remove(imports);
        } else if (base instanceof PluginBase) {
            ((PluginBase)base).remove(imports);
        } else if (base instanceof PluginBaseNode) {
            ((PluginBaseNode)base).remove(imports);
        }
    }

    private void removeDependencies(IBundle bundle, IPluginImport[] imports) {
        String oldValue = bundle.getHeader("Require-Bundle");
        if (oldValue == null || oldValue.equals("")) {
            return;
        }
        ArrayList<String> values = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(oldValue, ",");
        while (stk.hasMoreTokens()) {
            values.add(stk.nextToken().trim());
        }
        IPluginImport[] iPluginImportArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginImport dep = iPluginImportArray[n2];
            String name = dep.getId();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String requiredDep = (String)iterator.next();
                if (!requiredDep.startsWith(name)) continue;
                iterator.remove();
            }
            ++n2;
        }
        String newValue = null;
        int i = 0;
        while (i < values.size()) {
            newValue = newValue == null ? (String)values.get(i) : String.valueOf(newValue) + "," + (String)values.get(i);
            ++i;
        }
        bundle.setHeader("Require-Bundle", newValue);
    }
}

