/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.animation;

import java.net.URL;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.tests.XWTTestCase;
import org.eclipse.e4.xwt.tests.animation.Color_Background_Composite;
import org.eclipse.e4.xwt.tests.animation.Color_Foreground_Composite;
import org.eclipse.e4.xwt.tests.animation.Int_Alpha_Shell;
import org.eclipse.e4.xwt.tests.animation.Point_Location_Shell;
import org.eclipse.e4.xwt.tests.animation.Point_Size_Shell;
import org.eclipse.e4.xwt.tests.animation.Rectangle_Bounds_Shell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class AnimationTests
extends XWTTestCase {
    protected Color initialColor;
    protected int initialInt;
    protected Point initialLocation;
    protected Point initialSize;
    protected Rectangle initialBounds;

    public void test_Color_Background() throws Exception {
        URL url = Color_Background_Composite.class.getResource(String.valueOf(Color_Background_Composite.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                try {
                    Object element = XWT.findElementByName((Object)AnimationTests.this.root, (String)"startButton");
                    AnimationTests.assertTrue((boolean)(element instanceof Button));
                    Button button = (Button)element;
                    AnimationTests.this.selectButton(button);
                    element = XWT.findElementByName((Object)AnimationTests.this.root, (String)"labelTarget");
                    AnimationTests.assertTrue((boolean)(element instanceof Label));
                    Label label = (Label)element;
                    AnimationTests.this.initialColor = label.getBackground();
                }
                catch (Exception exception) {
                    AnimationTests.fail();
                }
            }
        }, new Runnable(){

            public void run() {
                try {
                    Thread.currentThread();
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }, new Runnable(){

            public void run() {
                try {
                    Object element = XWT.findElementByName((Object)AnimationTests.this.root, (String)"labelTarget");
                    AnimationTests.assertTrue((boolean)(element instanceof Label));
                    Label label = (Label)element;
                    Color color = label.getBackground();
                    AnimationTests.assertNotSame((Object)AnimationTests.this.initialColor, (Object)color);
                }
                catch (Exception exception) {
                    AnimationTests.fail();
                }
            }
        });
    }

    public void test_Color_Foreground() throws Exception {
        URL url = Color_Foreground_Composite.class.getResource(String.valueOf(Color_Foreground_Composite.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                try {
                    Object element = XWT.findElementByName((Object)AnimationTests.this.root, (String)"startButton");
                    AnimationTests.assertTrue((boolean)(element instanceof Button));
                    Button button = (Button)element;
                    AnimationTests.this.selectButton(button);
                    element = XWT.findElementByName((Object)AnimationTests.this.root, (String)"labelTarget");
                    AnimationTests.assertTrue((boolean)(element instanceof Label));
                    Label label = (Label)element;
                    AnimationTests.this.initialColor = label.getForeground();
                }
                catch (Exception exception) {
                    AnimationTests.fail();
                }
            }
        }, new Runnable(){

            public void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }, new Runnable(){

            public void run() {
                try {
                    Object element = XWT.findElementByName((Object)AnimationTests.this.root, (String)"labelTarget");
                    AnimationTests.assertTrue((boolean)(element instanceof Label));
                    Label label = (Label)element;
                    Color color = label.getForeground();
                    AnimationTests.assertNotSame((Object)AnimationTests.this.initialColor, (Object)color);
                }
                catch (Exception exception) {
                    AnimationTests.fail();
                }
            }
        });
    }

    public void test_Int_Alpha() throws Exception {
        URL url = Int_Alpha_Shell.class.getResource(String.valueOf(Int_Alpha_Shell.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                try {
                    Object element = XWT.findElementByName((Object)AnimationTests.this.root, (String)"startButton");
                    AnimationTests.assertTrue((boolean)(element instanceof Button));
                    Button button = (Button)element;
                    AnimationTests.this.selectButton(button);
                    element = XWT.findElementByName((Object)AnimationTests.this.root, (String)"window");
                    AnimationTests.assertTrue((boolean)(element instanceof Shell));
                    Shell shell = (Shell)element;
                    AnimationTests.this.initialInt = shell.getAlpha();
                }
                catch (Exception exception) {
                    AnimationTests.fail();
                }
            }
        }, new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }, new Runnable(){

            public void run() {
                try {
                    Object element = XWT.findElementByName((Object)AnimationTests.this.root, (String)"window");
                    AnimationTests.assertTrue((boolean)(element instanceof Shell));
                    Shell shell = (Shell)element;
                    int alpha = shell.getAlpha();
                    if (!"gtk".equals(SWT.getPlatform())) {
                        AnimationTests.assertTrue((alpha != AnimationTests.this.initialInt ? 1 : 0) != 0);
                    }
                }
                catch (Exception exception) {
                    AnimationTests.fail();
                }
            }
        });
    }

    public void test_Point_Location_Shell() throws Exception {
        URL url = Point_Location_Shell.class.getResource(String.valueOf(Point_Location_Shell.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                try {
                    Object element = XWT.findElementByName((Object)AnimationTests.this.root, (String)"startButton");
                    AnimationTests.assertTrue((boolean)(element instanceof Button));
                    Button button = (Button)element;
                    AnimationTests.this.selectButton(button);
                    element = XWT.findElementByName((Object)AnimationTests.this.root, (String)"window");
                    AnimationTests.assertTrue((boolean)(element instanceof Shell));
                    Shell shell = (Shell)element;
                    AnimationTests.this.initialLocation = shell.getLocation();
                }
                catch (Exception exception) {
                    AnimationTests.fail();
                }
            }
        }, new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }, new Runnable(){

            public void run() {
                try {
                    Object element = XWT.findElementByName((Object)AnimationTests.this.root, (String)"window");
                    AnimationTests.assertTrue((boolean)(element instanceof Shell));
                    Shell shell = (Shell)element;
                    Point location = shell.getLocation();
                    AnimationTests.assertNotSame((Object)AnimationTests.this.initialLocation, (Object)location);
                }
                catch (Exception exception) {
                    AnimationTests.fail();
                }
            }
        });
    }

    public void test_Point_Size_Shell() throws Exception {
        URL url = Point_Size_Shell.class.getResource(String.valueOf(Point_Size_Shell.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                try {
                    Object element = XWT.findElementByName((Object)AnimationTests.this.root, (String)"startButton");
                    AnimationTests.assertTrue((boolean)(element instanceof Button));
                    Button button = (Button)element;
                    AnimationTests.this.selectButton(button);
                    element = XWT.findElementByName((Object)AnimationTests.this.root, (String)"window");
                    AnimationTests.assertTrue((boolean)(element instanceof Shell));
                    Shell shell = (Shell)element;
                    AnimationTests.this.initialSize = shell.getSize();
                }
                catch (Exception exception) {
                    AnimationTests.fail();
                }
            }
        }, new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }, new Runnable(){

            public void run() {
                try {
                    Object element = XWT.findElementByName((Object)AnimationTests.this.root, (String)"window");
                    AnimationTests.assertTrue((boolean)(element instanceof Shell));
                    Shell shell = (Shell)element;
                    Point size = shell.getSize();
                    AnimationTests.assertNotSame((Object)AnimationTests.this.initialSize, (Object)size);
                }
                catch (Exception exception) {
                    AnimationTests.fail();
                }
            }
        });
    }

    public void test_Rectangle_Bounds_Shell() throws Exception {
        URL url = Rectangle_Bounds_Shell.class.getResource(String.valueOf(Rectangle_Bounds_Shell.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                try {
                    Object element = XWT.findElementByName((Object)AnimationTests.this.root, (String)"startButton");
                    AnimationTests.assertTrue((boolean)(element instanceof Button));
                    Button button = (Button)element;
                    AnimationTests.this.selectButton(button);
                    element = XWT.findElementByName((Object)AnimationTests.this.root, (String)"window");
                    AnimationTests.assertTrue((boolean)(element instanceof Shell));
                    Shell shell = (Shell)element;
                    AnimationTests.this.initialBounds = shell.getBounds();
                }
                catch (Exception exception) {
                    AnimationTests.fail();
                }
            }
        }, new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }, new Runnable(){

            public void run() {
                try {
                    Object element = XWT.findElementByName((Object)AnimationTests.this.root, (String)"window");
                    AnimationTests.assertTrue((boolean)(element instanceof Shell));
                    Shell shell = (Shell)element;
                    Rectangle rectangle = shell.getBounds();
                    AnimationTests.assertNotSame((Object)AnimationTests.this.initialBounds, (Object)rectangle);
                }
                catch (Exception exception) {
                    AnimationTests.fail();
                }
            }
        });
    }
}

