/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.stringconverters;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.tm.builder.IClassResolver;
import org.eclipse.e4.tm.stringconverters.AbstractClassStringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassStringConverter
extends AbstractClassStringConverter
implements IClassResolver {
    private static Map<String, Class<?>> primitiveTypes = new HashMap();
    private static Map<Class<?>, Class<?>> wrapperPrimitiveMap;
    private ClassLoader classLoader = this.getClass().getClassLoader();

    static {
        primitiveTypes.put("int", Integer.TYPE);
        primitiveTypes.put("byte", Byte.TYPE);
        primitiveTypes.put("short", Short.TYPE);
        primitiveTypes.put("long", Long.TYPE);
        primitiveTypes.put("double", Double.TYPE);
        primitiveTypes.put("float", Float.TYPE);
        primitiveTypes.put("boolean", Boolean.TYPE);
        primitiveTypes.put("char", Character.TYPE);
        wrapperPrimitiveMap = new HashMap();
        ClassStringConverter.addPrimitiveType(Integer.TYPE, Integer.class);
        ClassStringConverter.addPrimitiveType(Byte.TYPE, Byte.class);
        ClassStringConverter.addPrimitiveType(Short.TYPE, Short.class);
        ClassStringConverter.addPrimitiveType(Long.TYPE, Long.class);
        ClassStringConverter.addPrimitiveType(Double.TYPE, Double.class);
        ClassStringConverter.addPrimitiveType(Float.TYPE, Float.class);
        ClassStringConverter.addPrimitiveType(Boolean.TYPE, Boolean.class);
        ClassStringConverter.addPrimitiveType(Character.TYPE, Character.class);
    }

    public ClassStringConverter() {
        this.trim = true;
        this.importPackage("java.lang");
        this.resolvedClasses.putAll(primitiveTypes);
    }

    public static Class<?> getPrimitiveType(String s) {
        return primitiveTypes.get(s);
    }

    private static void addPrimitiveType(Class<?> primitive, Class<?> wrapper) {
        wrapperPrimitiveMap.put(primitive, wrapper);
        wrapperPrimitiveMap.put(wrapper, primitive);
    }

    public static Class<?> getPrimitiveType(Class<?> c) {
        if (c.isPrimitive()) {
            return c;
        }
        Class<?> pc = wrapperPrimitiveMap.get(c);
        return pc != null && pc.isPrimitive() ? pc : null;
    }

    public static <T> Class<T> getObjectClass(Class<T> c) {
        if (!c.isPrimitive()) {
            return c;
        }
        Class<?> wc = wrapperPrimitiveMap.get(c);
        return wc;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classloader) {
        this.classLoader = classloader;
        this.resolvedClasses = new HashMap(primitiveTypes);
    }

    @Override
    protected Class<?> loadClass(String name) throws Exception {
        return this.classLoader.loadClass(name);
    }
}

