/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.builder;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.tm.builder.BinderFactory;
import org.eclipse.e4.tm.builder.EClassNameBinderFactory;
import org.eclipse.e4.tm.builder.IBinder;
import org.eclipse.e4.tm.builder.IBinderContext;
import org.eclipse.e4.tm.builder.IBuilder;
import org.eclipse.e4.tm.builder.IBuilderListener;
import org.eclipse.e4.tm.builder.ReflectionSupport;
import org.eclipse.e4.tm.stringconverter.StringConversion;
import org.eclipse.e4.tm.stringconverter.StringConverterContext;
import org.eclipse.e4.tm.stringconverters.AbstractClassStringConverter;
import org.eclipse.e4.tm.stringconverters.ClassStringConverter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuilder
implements IBuilder,
StringConverterContext,
IBinderContext {
    private Object root = null;
    private URIConverter uriConverter;
    private List<Object> disposables = new ArrayList<Object>();
    private StringConversion stringConversion = new StringConversion();
    private AbstractClassStringConverter classResolver;
    private Map<EObject, Object> eObject2ObjectMap;
    private Map<Object, EObject> object2EObjectMap;
    private List<IBuilderListener> builderListeners;
    private BinderFactory binderFactory;
    private ReflectionSupport reflectionSupport;

    public AbstractBuilder() {
        this.stringConversion.setStringConverterContext(this);
        this.classResolver = new ClassStringConverter();
        this.eObject2ObjectMap = new HashMap<EObject, Object>();
        this.object2EObjectMap = new HashMap<Object, EObject>();
        this.builderListeners = new ArrayList<IBuilderListener>();
        this.binderFactory = new EClassNameBinderFactory(this);
        this.reflectionSupport = new ReflectionSupport(this);
    }

    protected Object getToolkitComposite(Object context, Class<?> c) {
        if (c.isInstance(context)) {
            return context;
        }
        if (context instanceof IAdaptable) {
            return ((IAdaptable)context).getAdapter(c);
        }
        return null;
    }

    @Override
    public <T> T getRootObject(Class<T> c) {
        return this.adapt(this.root, c);
    }

    public void build(EObject control, Object context) {
        this.root = context;
        this.update(control);
        this.fireObjectHandled(1, control, context);
    }

    public URIConverter getUriConverter() {
        if (this.uriConverter == null) {
            this.uriConverter = new ExtensibleURIConverterImpl();
        }
        return this.uriConverter;
    }

    @Override
    public void build(Resource res, Object context) {
        EObject eObject = (EObject)res.getContents().get(0);
        this.build(eObject, context);
    }

    @Override
    public void registerDisposable(Object disposable) {
        this.disposables.add(disposable);
    }

    public StringConversion getStringConverter() {
        return this.stringConversion;
    }

    @Override
    public <T> T convert(String value, Class<T> klass) throws Exception {
        return this.stringConversion.convert(value, klass);
    }

    public AbstractClassStringConverter getClassResolver() {
        return this.classResolver;
    }

    @Override
    public Class<?> resolve(String className) {
        return this.classResolver.resolve(className);
    }

    @Override
    public void dispose() {
        for (Object disposable : this.disposables) {
            AbstractBuilder.dispose(disposable);
        }
        for (EObject eObject : this.eObject2ObjectMap.keySet()) {
            this.dispose(eObject);
        }
        this.eObject2ObjectMap.clear();
    }

    static void dispose(Object disposable) {
        try {
            disposable.getClass().getMethod("dispose", new Class[0]).invoke(disposable, new Object[0]);
        }
        catch (Exception exception) {}
    }

    public static String getClassAnnotation(EClass eClass, String uri, String key, String def) {
        ArrayList<EClass> superClasses = new ArrayList<EClass>((Collection<EClass>)eClass.getEAllSuperTypes());
        superClasses.add(0, eClass);
        for (EClass superClass : superClasses) {
            String value = EcoreUtil.getAnnotation((EModelElement)superClass, (String)uri, (String)key);
            if (value == null) continue;
            return value;
        }
        return def;
    }

    public static String getFeatureAnnotation(EStructuralFeature feature, EClass realClass, String uri, String key, String def) {
        String value = null;
        EClass subClass = realClass;
        while (value == null && subClass != null && subClass != feature.eContainer()) {
            String altUri = String.valueOf(uri) + "#" + subClass.getName();
            value = EcoreUtil.getAnnotation((EModelElement)feature, (String)altUri, (String)key);
            EList superTypes = subClass.getESuperTypes();
            EClass eClass = subClass = superTypes.size() > 0 ? (EClass)superTypes.get(0) : null;
        }
        if (value == null) {
            value = EcoreUtil.getAnnotation((EModelElement)feature, (String)uri, (String)key);
        }
        if (value == null) {
            value = AbstractBuilder.getClassAnnotation(feature.getEContainingClass(), uri, key, def);
        }
        return value;
    }

    public static String getAnnotation(EModelElement element, String uri, String key, String def) {
        String value = EcoreUtil.getAnnotation((EModelElement)element, (String)uri, (String)key);
        return value != null ? value : def;
    }

    public static String casify(String s, Boolean cas) {
        if (s.length() > 0 && cas != null) {
            char first = s.charAt(0);
            s = String.valueOf(cas != false ? Character.toUpperCase(first) : Character.toLowerCase(first)) + s.substring(1);
        }
        return s;
    }

    @Override
    public <T> T getObject(EObject eObject, Class<T> c) {
        return this.getObject(eObject, c, false);
    }

    @Override
    public EObject getEObject(Object object) {
        return this.object2EObjectMap.get(object);
    }

    @Override
    public void putObject(EObject eObject, Object object) {
        this.eObject2ObjectMap.put(eObject, object);
        if (object != null) {
            this.object2EObjectMap.put(object, eObject);
        }
    }

    protected <T> T getObject(EObject eObject, Class<T> c, boolean searchContainers) {
        EObject eO = eObject;
        while ((eO == eObject || searchContainers) && eO != null) {
            Object o = this.eObject2ObjectMap.get(eO);
            if (!c.isInstance(o)) {
                o = this.adapt(eO, o, c);
            }
            if (c.isInstance(o)) {
                return (T)o;
            }
            eO = eO.eContainer();
        }
        return null;
    }

    @Override
    public void addBuilderListener(IBuilderListener listener) {
        this.builderListeners.add(listener);
    }

    @Override
    public void removeBuilderListener(IBuilderListener listener) {
        this.builderListeners.remove(listener);
    }

    @Override
    public void fireObjectHandled(int id, EObject eObject, Object object) {
        for (IBuilderListener listener : this.builderListeners) {
            listener.objectHandled(id, eObject, object);
        }
    }

    @Override
    public Object update(EObject eObject) {
        Object object = this.eObject2ObjectMap.get(eObject);
        IBinder binder = this.getBinder(eObject, true);
        Object newObject = binder.update(eObject, object, this);
        if (newObject != null) {
            this.eObject2ObjectMap.put(eObject, newObject);
        }
        this.fireObjectHandled(2, eObject, object);
        return newObject;
    }

    @Override
    public void dispose(EObject eObject) {
        IBinder binder;
        Object object = this.eObject2ObjectMap.get(eObject);
        if (object != null && (binder = this.getBinder(eObject, false)) != null) {
            binder.dispose(eObject, object, this);
            this.fireObjectHandled(3, eObject, object);
        }
    }

    @Override
    public void updateStyle(EObject eObject) {
        Object object = this.eObject2ObjectMap.get(eObject);
        IBinder binder = this.getBinder(eObject, false);
        if (binder != null) {
            binder.updateStyle(eObject, object, this);
        }
        this.fireObjectHandled(4, eObject, object);
    }

    protected IBinder getBinder(EObject eObject, boolean throwException) {
        IBinder binder = this.binderFactory.getBinder(eObject);
        if (binder == null && throwException) {
            throw new RuntimeException("Couldn't get IBinder for eClass " + eObject.eClass().getName());
        }
        return binder;
    }

    public <T> T adapt(EObject eObject, Object value, Class<T> c) {
        if (eObject == null) {
            return this.adapt(value, c);
        }
        IBinder binder = this.getBinder(eObject, true);
        T o = binder.adapt(value, c);
        if (!c.isInstance(o)) {
            o = this.adapt(value, c);
        }
        return (T)(c.isInstance(o) ? o : null);
    }

    @Override
    public <T> T adapt(Object value, Class<T> c) {
        if (c.isPrimitive()) {
            c = ClassStringConverter.getObjectClass(c);
        }
        if (value == null) {
            if (c == URIConverter.class) {
                return (T)this.getUriConverter();
            }
            return this.getRootObject(c);
        }
        if (c.isInstance(value)) {
            return (T)value;
        }
        if (value instanceof Collection && c.isArray()) {
            Collection collection = (Collection)value;
            Class<?> elementType = c.getComponentType();
            Object array = Array.newInstance(elementType, collection.size());
            int i = 0;
            for (Object o : collection) {
                Object o2 = this.adapt(o, elementType);
                Array.set(array, i++, o2);
            }
            return (T)array;
        }
        if (value instanceof String) {
            return this.getStringConverter().convert((String)value, c);
        }
        return null;
    }

    @Override
    public void invalidateFeature(EObject eObject, String featureName) {
        while (eObject != null) {
            IBinder binder = this.getBinder(eObject, false);
            if (binder != null && binder.validateFeature(eObject, this.getObject(eObject, Object.class), featureName, this)) break;
            eObject = eObject.eContainer();
        }
    }

    public Method getMethod(Object object, String signature) {
        return this.reflectionSupport.getMethod(object, signature);
    }

    @Override
    public Object getGetterProperty(Object object, String name) {
        return this.reflectionSupport.getGetterProperty(object, name);
    }

    @Override
    public Object getMethodProperty(Object object, String methodSpec, Object[] args) {
        return this.reflectionSupport.getMethodProperty(object, methodSpec, args);
    }

    @Override
    public Object getFieldProperty(Object object, String name) {
        return this.reflectionSupport.getFieldProperty(object, name);
    }

    @Override
    public Exception setSetterProperty(Object object, String name, Object value) {
        return this.reflectionSupport.setSetterProperty(object, name, value);
    }

    @Override
    public Exception setMethodProperty(Object object, String methodSpec, Object[] args) {
        return this.reflectionSupport.setMethodProperty(object, methodSpec, args);
    }

    @Override
    public Exception setFieldProperty(Object object, String name, Object value) {
        return this.reflectionSupport.setFieldProperty(object, name, value);
    }

    @Override
    public void setProperty(Object object, String name, Object value) throws Exception {
        this.reflectionSupport.setProperty(object, name, value);
    }
}

