/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.pde.internal.webui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.pde.internal.webui.Activator;
import org.eclipse.e4.pde.internal.webui.EMFJSONUtil;
import org.eclipse.e4.pde.internal.webui.JSONUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.osgi.framework.Version;

public class PDEServlet
extends HttpServlet {
    private static final long serialVersionUID = -5263759597889185038L;
    private IWorkspace workspace;
    private static String sessionID;

    private synchronized IWorkspace getWorkspace() {
        if (this.workspace == null) {
            new InstanceScope().getNode("org.eclipse.core.resources").putBoolean("refresh.enabled", true);
            this.workspace = ResourcesPlugin.getWorkspace();
        }
        return this.workspace;
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.isAuthenticated(req)) {
            resp.setStatus(403);
            return;
        }
        String pathInfo = req.getPathInfo();
        if (pathInfo.startsWith("/site/")) {
            String wsPath = pathInfo.substring("/site".length());
            IResource resource = this.getWorkspace().getRoot().findMember((IPath)new Path(wsPath));
            if (resource.getType() != 1) {
                resp.setStatus(405);
                return;
            }
            ServletInputStream is = req.getInputStream();
            int BUFFER_SIZE = 8192;
            byte[] buffer = new byte[BUFFER_SIZE];
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int numRead = 0;
            while ((numRead = is.read(buffer)) > 0) {
                os.write(buffer, 0, numRead);
            }
            String jsonString = new String(os.toByteArray(), "ISO-8859-1");
            Object json = JSONUtil.read(jsonString);
            URI siteEcoreURI = URI.createPlatformPluginURI((String)"/org.eclipse.e4.pde.webui/model/Site.ecore", (boolean)true);
            ResourceSet resourceSet = this.createResourceSet(siteEcoreURI);
            EPackage ePackage = resourceSet.getPackageRegistry().getEPackage("platform:/plugin/org.eclipse.e4.pde.site.model/site.xsd");
            Resource.Factory factory = (Resource.Factory)resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().get("*");
            URI uri = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
            Resource r = factory.createResource(uri);
            EClass documentRootClass = (EClass)ePackage.getEClassifier("DocumentRoot");
            EObject documentRoot = ePackage.getEFactoryInstance().create(documentRootClass);
            EClass siteClass = (EClass)ePackage.getEClassifier("Site");
            EObject site = ePackage.getEFactoryInstance().create(siteClass);
            this.fill(site, (HashMap)json, ePackage.getEFactoryInstance());
            documentRoot.eSet(documentRootClass.getEStructuralFeature("site"), (Object)site);
            r.getContents().add((Object)documentRoot);
            OutputStream outputStream = resourceSet.getURIConverter().createOutputStream(uri);
            r.save(outputStream, new HashMap());
            outputStream.close();
        }
    }

    private void fill(EObject eObject, HashMap json, EFactory eFactory) {
        for (Map.Entry entry : json.entrySet()) {
            EStructuralFeature feature = eObject.eClass().getEStructuralFeature((String)entry.getKey());
            if (entry.getValue() instanceof Collection) {
                Collection targetCollection = (Collection)eObject.eGet(feature);
                Collection sourceCollection = (Collection)entry.getValue();
                for (Object element : sourceCollection) {
                    EClass elementClass = (EClass)feature.getEType();
                    EObject targetElement = eFactory.create(elementClass);
                    this.fill(targetElement, (HashMap)element, eFactory);
                    targetCollection.add(targetElement);
                }
                continue;
            }
            if (entry.getValue() instanceof Map) {
                EClass elementClass = (EClass)feature.getEType();
                EObject targetElement = eFactory.create(elementClass);
                this.fill(targetElement, (HashMap)entry.getValue(), eFactory);
                eObject.eSet(feature, (Object)targetElement);
                continue;
            }
            if (entry.getValue() instanceof String) {
                eObject.eSet(feature, entry.getValue());
                continue;
            }
            if (entry.getValue() == null) continue;
            throw new RuntimeException("unsupported: " + entry.getValue());
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        String pathInfo = req.getPathInfo();
        if (pathInfo.startsWith("/login") && "e4".equals(req.getParameter("username")) && "e4".equals(req.getParameter("password"))) {
            resp.addCookie(new Cookie("org.eclipse.e4.pde.auth", PDEServlet.getSessionId()));
            try {
                resp.sendRedirect(req.getParameter("nextURL"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            resp.sendRedirect("/pde/login?nextURL=" + URLEncoder.encode(req.getParameter("nextURL"), "UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo.startsWith("/login")) {
            resp.setStatus(200);
            resp.setContentType("text/html; charset=UTF-8");
            PrintWriter writer = resp.getWriter();
            writer.append("<html>");
            writer.append("<head>");
            writer.append("<title>Please Log In</title>");
            writer.append("</head>");
            writer.append("<body>");
            writer.append("<form method='post' action='/pde/login'>");
            writer.append("username: ");
            writer.append("<input type='text' name='username' />");
            writer.append("<br />");
            writer.append("password: ");
            writer.append("<input type='password' name='password' />");
            writer.append("<br />");
            writer.append("<input type='submit' value='Login' />");
            writer.append("<input type='hidden' name='nextURL' value='" + req.getParameter("nextURL") + "' />");
            writer.append("</form>");
            if (Activator.DEBUG) {
                writer.append("<script type='text/javascript' src='/listCookies.js'></script>");
            }
            writer.append("</body>");
            writer.append("</html>");
            return;
        }
        if (!this.isAuthenticated(req)) {
            resp.setStatus(403);
            return;
        }
        if (pathInfo.startsWith("/features/")) {
            IFeatureModel[] allModels = PDECore.getDefault().getFeatureModelManager().getModels();
            Arrays.sort(allModels, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    IFeature f0 = ((IFeatureModel)arg0).getFeature();
                    IFeature f1 = ((IFeatureModel)arg1).getFeature();
                    return f0.getId().compareTo(f1.getId());
                }
            });
            ArrayList features = new ArrayList(allModels.length);
            int i = 0;
            while (i < allModels.length) {
                IFeature feature = allModels[i].getFeature();
                HashMap<String, String> featureJSON = new HashMap<String, String>();
                featureJSON.put("feature", null);
                featureJSON.put("id", feature.getId());
                featureJSON.put("url", "features/" + feature.getId() + "_" + new Version(feature.getVersion()).toString() + ".jar");
                featureJSON.put("version", feature.getVersion());
                features.add(featureJSON);
                ++i;
            }
            resp.setStatus(200);
            resp.setContentType("application/json; charset=UTF-8");
            HashMap<String, Object> jsonResult = new HashMap<String, Object>();
            jsonResult.put("identifier", "id");
            jsonResult.put("label", "id");
            jsonResult.put("items", features);
            PrintWriter writer = resp.getWriter();
            writer.write("/*");
            writer.write(JSONUtil.write(jsonResult));
            writer.write("*/");
            return;
        }
        if (pathInfo.startsWith("/site/")) {
            String wsPath = pathInfo.substring("/site".length());
            IResource resource = this.getWorkspace().getRoot().findMember((IPath)new Path(wsPath));
            if (resource.getType() != 1) {
                resp.setStatus(405);
                return;
            }
            PrintWriter writer = resp.getWriter();
            try {
                URI siteEcoreURI = URI.createPlatformPluginURI((String)"/org.eclipse.e4.pde.webui/model/Site.ecore", (boolean)true);
                ResourceSet resourceSet = this.createResourceSet(siteEcoreURI);
                URI uri = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
                Resource r = resourceSet.getResource(uri, true);
                EObject eRootObject = (EObject)r.getContents().get(0);
                resp.setStatus(200);
                resp.setContentType("application/json; charset=UTF-8");
                writer.write("/*");
                writer.write(EMFJSONUtil.write((EObject)eRootObject.eContents().get(0)));
                writer.write("*/");
                return;
            }
            catch (Exception e) {
                e.printStackTrace(writer);
                resp.setStatus(500);
                return;
            }
        }
    }

    private boolean isAuthenticated(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                if (cookies[i].getName().equals("org.eclipse.e4.pde.auth") && cookies[i].getValue().equals(PDEServlet.getSessionId())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String getSessionId() {
        if (sessionID == null) {
            sessionID = UUID.randomUUID().toString();
        }
        return sessionID;
    }

    private ResourceSet createResourceSet(URI siteEcoreURI) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource ecoreResource = resourceSet.getResource(siteEcoreURI, true);
        final BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData((EPackage.Registry)new EPackageRegistryImpl(EPackage.Registry.INSTANCE));
        EPackage ecorePackage = (EPackage)ecoreResource.getContents().get(0);
        extendedMetaData.putPackage(null, ecorePackage);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ResourceFactoryImpl(){

            public Resource createResource(URI uri) {
                XMLResourceImpl result = new XMLResourceImpl(uri);
                result.getDefaultSaveOptions().put("EXTENDED_META_DATA", extendedMetaData);
                result.getDefaultLoadOptions().put("EXTENDED_META_DATA", extendedMetaData);
                result.getDefaultSaveOptions().put("SCHEMA_LOCATION", Boolean.TRUE);
                result.getDefaultLoadOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
                result.getDefaultSaveOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
                result.getDefaultLoadOptions().put("USE_LEXICAL_HANDLER", Boolean.TRUE);
                return result;
            }
        });
        resourceSet.getPackageRegistry().put((Object)ecorePackage.getNsURI(), (Object)ecorePackage);
        return resourceSet;
    }
}

