/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.ecore.javascript;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptClassLoader
extends ClassLoader {
    private URI uri;
    private URIConverter uriConverter;
    private static final String jsClassNameSuffix = "$js";
    private byte[] buffer = new byte[10240];
    private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();

    public ScriptClassLoader(ClassLoader parent) {
        super(parent);
    }

    void setUri(URI uri, URIConverter uriConverter) {
        this.uri = uri;
        this.uriConverter = uriConverter;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return super.loadClass(name);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytes = null;
        if (name.equals(ScriptClassLoader.getUriClassName(this.uri))) {
            try {
                bytes = this.loadClassData(name);
            }
            catch (IOException iOException) {}
        }
        return bytes != null ? this.defineClass(name, bytes, 0, bytes.length) : super.findClass(name);
    }

    public static String getUriClassName(URI uri) {
        String className = uri.trimFileExtension().lastSegment();
        if (uri.isPlatform()) {
            String[] segments = uri.segments();
            int i = 2;
            while (i < segments.length - 1) {
                className = String.valueOf(segments[i]) + "." + className;
                ++i;
            }
        }
        return className.endsWith(jsClassNameSuffix) ? className : String.valueOf(className) + jsClassNameSuffix;
    }

    public static boolean hasUriClassNameMarker(String className) {
        return className.endsWith(jsClassNameSuffix);
    }

    private byte[] loadClassData(String name) throws IOException {
        InputStream input = this.uriConverter.createInputStream(this.uri);
        int length = 0;
        this.byteArrayOutputStream.reset();
        while ((length = input.read(this.buffer, 0, this.buffer.length)) >= 0) {
            this.byteArrayOutputStream.write(this.buffer, 0, length);
        }
        return this.byteArrayOutputStream.toByteArray();
    }
}

