/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.javascript.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelectionView
extends ViewPart {
    protected IEditingDomainProvider editingDomainProvider;
    protected ISelectionProvider selectionProvider;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            AbstractSelectionView.this.updateProviders(part);
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            AbstractSelectionView.this.updateProviders(part);
        }

        public void partClosed(IWorkbenchPart part) {
            AbstractSelectionView.this.updateProviders(part);
        }

        public void partDeactivated(IWorkbenchPart part) {
            AbstractSelectionView.this.updateProviders(part);
        }

        public void partOpened(IWorkbenchPart part) {
            AbstractSelectionView.this.updateProviders(part);
        }
    };
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            AbstractSelectionView.this.selectionChanged(event.getSelection());
        }
    };
    protected Object selection = null;
    private TextActionHandler textActionHandler;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        this.setEditingDomainProvider(null);
        super.dispose();
    }

    protected void setEditingDomainProvider(IEditingDomainProvider editingDomainProvider) {
        if (this.editingDomainProvider == editingDomainProvider) {
            return;
        }
        this.editingDomainProvider = editingDomainProvider;
        this.updateView();
    }

    protected void updateView() {
    }

    public Object getAdapter(Class type) {
        Object o = super.getAdapter(type);
        if (o == null && this.editingDomainProvider instanceof IAdaptable) {
            o = ((IAdaptable)this.editingDomainProvider).getAdapter(type);
        }
        return o;
    }

    private void updateProviders(IWorkbenchPart part) {
        this.setSelectionProvider(this.getAdapter(part, ISelectionProvider.class));
        this.setEditingDomainProvider(this.getAdapter(part, IEditingDomainProvider.class));
    }

    protected <T> T getAdapter(IWorkbenchPart part, Class<T> c) {
        IWorkbenchPage workbenchPage = this.getViewSite().getWorkbenchWindow().getActivePage();
        if (workbenchPage == null) {
            return null;
        }
        IEditorPart editorPart = workbenchPage.getActiveEditor();
        return (T)(editorPart != null ? editorPart.getAdapter(c) : null);
    }

    protected void setSelectionProvider(ISelectionProvider selectionProvider) {
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener(this.selectionChangedListener);
            this.selectionChanged((ISelection)StructuredSelection.EMPTY);
        }
        this.selectionProvider = selectionProvider;
        if (this.selectionProvider != null) {
            this.selectionProvider.addSelectionChangedListener(this.selectionChangedListener);
            this.selectionChanged(this.selectionProvider.getSelection());
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionChanged(event.getSelection());
    }

    protected void selectionChanged(ISelection selection) {
        Object o;
        Object oldSelection = this.selection;
        this.selection = null;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && this.isValidSelection(o = ((IStructuredSelection)selection).getFirstElement())) {
            this.selection = o;
        }
        if (this.selection != oldSelection) {
            this.updateView();
        }
    }

    protected boolean isValidSelection(Object o) {
        return true;
    }

    void registerTextControl(final Text textControl) {
        textControl.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AbstractSelectionView.this.textActionHandler.addText(textControl);
            }

            public void focusLost(FocusEvent e) {
                AbstractSelectionView.this.textActionHandler.removeText(textControl);
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.textActionHandler = new TextActionHandler(this.getViewSite().getActionBars());
        this.createActions();
        this.createMenu();
        this.createToolbar();
    }

    protected Text createTextControl(Composite parent, int style) {
        Text textControl = new Text(parent, style);
        this.textActionHandler.addText(textControl);
        return textControl;
    }

    protected void disposeTextControl(Text textControl) {
        if (!textControl.isDisposed()) {
            this.textActionHandler.removeText(textControl);
        }
    }

    protected void createActions() {
    }

    private void createMenu() {
        this.createMenu(this.getViewSite().getActionBars().getMenuManager());
    }

    protected void createMenu(IMenuManager mgr) {
    }

    private void createToolbar() {
        this.createToolbar(this.getViewSite().getActionBars().getToolBarManager());
    }

    protected void createToolbar(IToolBarManager mgr) {
    }
}

