/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.e4photo;

import java.util.LinkedList;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;

public class LockRealm
extends Realm {
    private LinkedList queue = new LinkedList();
    private ILock lock = Job.getJobManager().newLock();
    private Job job = new Job("Lock Realm Job"){

        protected IStatus run(IProgressMonitor monitor) {
            Runnable runnable;
            while ((runnable = LockRealm.this.dequeue()) != null) {
                LockRealm.this.acquireLock();
                try {
                    LockRealm.safeRun((Runnable)runnable);
                }
                finally {
                    LockRealm.this.releaseLock();
                }
            }
            return Status.OK_STATUS;
        }
    };
    private boolean lockAcquired;

    public LockRealm() {
        this.job.setSystem(true);
    }

    protected void syncExec(Runnable runnable) {
        this.acquireLock();
        try {
            LockRealm.safeRun((Runnable)runnable);
        }
        finally {
            this.releaseLock();
        }
    }

    public void asyncExec(Runnable runnable) {
        this.enqueue(runnable);
        this.job.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(Runnable runnable) {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.addLast(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable dequeue() {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            block4: {
                if (!this.queue.isEmpty()) break block4;
                return null;
            }
            return (Runnable)this.queue.removeFirst();
        }
    }

    public boolean isCurrent() {
        return this.lockAcquired;
    }

    private void acquireLock() {
        this.lock.acquire();
        this.lockAcquired = true;
    }

    private void releaseLock() {
        this.lockAcquired = false;
        this.lock.release();
    }
}

