/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.manual;

import java.text.NumberFormat;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.internal.tests.CoreTestsActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ContextExample {
    double total = 0.0;

    public static void main(String[] arguments) {
        new ContextExample().price();
    }

    public void run() {
        IEclipseContext parent = EclipseContextFactory.create();
        parent.set("complement", (Object)new ComplementaryColor());
        IEclipseContext context = parent.createChild();
        context.set("color", (Object)Color.YELLOW);
        Crayon crayon = new Crayon();
        ContextInjectionFactory.inject((Object)crayon, (IEclipseContext)context);
        crayon.draw();
    }

    public void runWithService() {
        BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
        ServiceRegistration reg = bundleContext.registerService(IPaletteService.class.getName(), (Object)new PaletteImpl(Color.BLUE), null);
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        Crayon crayon = new Crayon();
        ContextInjectionFactory.inject((Object)crayon, (IEclipseContext)context);
        crayon.draw();
        reg.unregister();
        crayon.draw();
    }

    public void run2() {
        IEclipseContext parent = EclipseContextFactory.create();
        parent.set("complement", (Object)new ComplementaryColor());
        IEclipseContext child = parent.createChild();
        child.set("color", (Object)Color.RED);
        System.out.println(child.get("color"));
        System.out.println(child.get("complement"));
    }

    public void run3() {
    }

    public void price() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("price", (Object)19.99);
        context.set("tax", (Object)0.05);
        context.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                ContextExample.this.total = (Double)context.get("price") * (1.0 + (Double)context.get("tax"));
                return true;
            }

            public String toString() {
                return "calculator";
            }
        });
        this.print(this.total);
        context.set("tax", (Object)0.07);
        this.print(this.total);
    }

    private void print(double price) {
        System.out.println(NumberFormat.getCurrencyInstance().format(price));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Color {
        RED,
        BLUE,
        YELLOW,
        GREEN,
        ORANGE,
        PURPLE;

    }

    static class ComplementaryColor
    extends ContextFunction {
        ComplementaryColor() {
        }

        public Object compute(IEclipseContext context) {
            switch ((Color)((Object)context.get("color"))) {
                case RED: {
                    return Color.GREEN;
                }
                case GREEN: {
                    return Color.RED;
                }
                case BLUE: {
                    return Color.ORANGE;
                }
                case ORANGE: {
                    return Color.BLUE;
                }
                case YELLOW: {
                    return Color.PURPLE;
                }
                case PURPLE: {
                    return Color.YELLOW;
                }
            }
            return null;
        }
    }

    class Crayon {
        @Inject
        IPaletteService pallete;

        Crayon() {
        }

        public void draw() {
            if (this.pallete == null) {
                System.out.println("No palette");
            } else {
                System.out.println("My pen is:  " + (Object)((Object)this.pallete.getColor()));
            }
        }
    }

    static interface IPaletteService {
        public Color getColor();
    }

    class PaletteImpl
    implements IPaletteService {
        private final Color color;

        PaletteImpl(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }

    static class ResourceSelection
    extends ContextFunction {
        ResourceSelection() {
        }

        public Object compute(IEclipseContext context) {
            return null;
        }
    }
}

