/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class TestConstructorInjection
extends TestCase {
    public void testConstructorInjection() throws InvocationTargetException, InstantiationException {
        IEclipseContext context = EclipseContextFactory.create();
        Integer intValue = new Integer(123);
        context.set(Integer.class.getName(), (Object)intValue);
        Boolean boolValue = new Boolean(true);
        context.set(Boolean.class.getName(), (Object)boolValue);
        Double doubleValue = new Double(1.23);
        context.set(Double.class.getName(), (Object)doubleValue);
        Float floatValue = new Float(12.3);
        context.set(Float.class.getName(), (Object)floatValue);
        Character charValue = new Character('v');
        context.set(Character.class.getName(), (Object)charValue);
        Object result = ContextInjectionFactory.make(TestConstructorObject.class, (IEclipseContext)context);
        TestConstructorInjection.assertNotNull((Object)result);
        TestConstructorInjection.assertTrue((boolean)(result instanceof TestConstructorObject));
        TestConstructorObject testObject = (TestConstructorObject)result;
        TestConstructorInjection.assertFalse((boolean)testObject.defaultConstructorCalled);
        TestConstructorInjection.assertFalse((boolean)testObject.constructorIntStrCalled);
        TestConstructorInjection.assertTrue((boolean)testObject.constructorIntBoolCalled);
        TestConstructorInjection.assertTrue((boolean)testObject.injectedMethodCalled);
        TestConstructorInjection.assertFalse((boolean)testObject.nonInjectedMethodCalled);
        TestConstructorInjection.assertTrue((boolean)testObject.orderCorrect);
        TestConstructorInjection.assertEquals((Object)intValue, (Object)testObject.i);
        TestConstructorInjection.assertEquals((Object)boolValue, (Object)testObject.b);
        TestConstructorInjection.assertEquals((Object)doubleValue, (Object)testObject.d);
        TestConstructorInjection.assertEquals((Object)floatValue, (Object)testObject.f);
        TestConstructorInjection.assertEquals((Object)charValue, (Object)testObject.getChar());
        TestConstructorInjection.assertNull((Object)testObject.s);
    }

    static class TestConstructorObject {
        public boolean defaultConstructorCalled = false;
        public boolean constructorIntStrCalled = false;
        public boolean constructorIntBoolCalled = false;
        public boolean injectedMethodCalled = false;
        public boolean nonInjectedMethodCalled = false;
        @Inject
        private Character c;
        public Integer i;
        public String s;
        public Boolean b;
        public Double d;
        public Float f;
        public boolean orderCorrect = true;

        public TestConstructorObject() {
            this.defaultConstructorCalled = true;
        }

        public TestConstructorObject(Integer i, String s) {
            this.constructorIntStrCalled = true;
            this.i = i;
            this.s = s;
        }

        @Inject
        public TestConstructorObject(Integer i, Boolean b) {
            this.constructorIntBoolCalled = true;
            this.i = i;
            this.b = b;
            if (this.c != null || this.d != null || this.f != null) {
                this.orderCorrect = false;
            }
        }

        @Inject
        public void injectedMethod(Double d, Float f) {
            this.injectedMethodCalled = true;
            this.d = d;
            this.f = f;
            if (this.c == null || this.i == null || this.b == null) {
                this.orderCorrect = false;
            }
        }

        public void nonInjectedMethod(Double d) {
            this.nonInjectedMethodCalled = true;
            this.d = d;
        }

        public Character getChar() {
            return this.c;
        }
    }
}

