/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.internal.tests.CoreTestsActivator;
import org.eclipse.e4.core.internal.tests.contexts.inject.PrintService;
import org.eclipse.e4.core.internal.tests.contexts.inject.StringPrintService;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceContextTest
extends TestCase {
    private IEclipseContext context;
    private final List<ServiceRegistration<?>> registrations = new ArrayList();

    protected void setUp() throws Exception {
        super.setUp();
        BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
        this.context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        this.registrations.clear();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        for (ServiceRegistration<?> reg : this.registrations) {
            try {
                reg.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.registrations.clear();
        this.context = null;
    }

    public void testDeclarativeService() {
        ServiceContextTest.assertTrue((boolean)this.context.containsKey("sum"));
        ServiceContextTest.assertEquals((Object)0, (Object)this.context.get("sum"));
        this.context.set("x", (Object)1);
        this.context.set("y", (Object)2);
        int result = (Integer)this.context.get("sum");
        ServiceContextTest.assertEquals((String)"1.0", (int)3, (int)result);
        this.context.set("x", (Object)5);
        result = (Integer)this.context.get("sum");
        ServiceContextTest.assertEquals((String)"1.0", (int)7, (int)result);
    }

    public void testServiceContextAsParent() {
        IEclipseContext child = this.context.createChild("child");
        DebugOptions service = (DebugOptions)child.get(DebugOptions.class.getName());
        ServiceContextTest.assertNotNull((Object)service);
    }

    public void testServiceInjection() {
        ServiceRegistration reg1 = null;
        ServiceRegistration reg2 = null;
        try {
            Printer userObject = new Printer();
            StringPrintService stringPrint1 = new StringPrintService();
            BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
            reg1 = bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrint1, null);
            ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)this.context);
            userObject.print("test");
            ServiceContextTest.assertEquals((String)"1.0", (String)"test", (String)stringPrint1.toString());
            reg1.unregister();
            reg1 = null;
            userObject.print("another test");
            ServiceContextTest.assertEquals((String)"1.1", (String)"test", (String)stringPrint1.toString());
            ServiceContextTest.assertNull((String)"1.2", (Object)userObject.printer);
            StringPrintService stringPrint2 = new StringPrintService();
            reg2 = bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrint2, null);
            userObject.print("yet another test");
            ServiceContextTest.assertEquals((String)"2.0", (String)"test", (String)stringPrint1.toString());
            ServiceContextTest.assertEquals((String)"2.1", (String)"yet another test", (String)stringPrint2.toString());
            reg2.unregister();
            reg2 = null;
            ServiceContextTest.assertNull((String)"2.2", (Object)userObject.printer);
        }
        finally {
            if (reg1 != null) {
                reg1.unregister();
                reg1 = null;
            }
            if (reg2 != null) {
                reg2.unregister();
                reg2 = null;
            }
        }
    }

    public void testServiceAddition() {
        ServiceRegistration reg1 = null;
        try {
            Printer userObject = new Printer();
            ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)this.context);
            StringPrintService stringPrint1 = new StringPrintService();
            BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
            reg1 = bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrint1, null);
            userObject.print("test");
            ServiceContextTest.assertEquals((String)"1.0", (String)"test", (String)stringPrint1.toString());
        }
        finally {
            if (reg1 != null) {
                reg1.unregister();
                reg1 = null;
            }
        }
    }

    protected void ensureUnregistered(ServiceRegistration<?> reg) {
        this.registrations.add(reg);
    }

    public void testServiceRemovalOnContextDispose() {
        StringPrintService stringPrint1 = new StringPrintService();
        BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
        ServiceRegistration reg1 = bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrint1, null);
        try {
            ServiceReference ref = reg1.getReference();
            PrintService service = (PrintService)this.context.get(PrintService.SERVICE_NAME);
            ServiceContextTest.assertEquals((String)"1.0", (Object)stringPrint1, (Object)service);
            ServiceContextTest.assertEquals((String)"1.1", (int)1, (int)ref.getUsingBundles().length);
            service = null;
            this.context.dispose();
            ServiceContextTest.assertNull((String)"2.0", (Object)ref.getUsingBundles());
        }
        finally {
            reg1.unregister();
        }
    }

    public void testRecursiveServiceRemoval() {
        BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
        ServiceRegistration reg1 = bundleContext.registerService(PrintService.SERVICE_NAME, (Object)new StringPrintService(), null);
        final IEclipseContext child = this.context.createChild();
        IEclipseContext child2 = this.context.createChild();
        child.get(PrintService.SERVICE_NAME);
        child2.get(PrintService.SERVICE_NAME);
        this.ensureUnregistered(reg1);
        final boolean[] done = new boolean[1];
        this.context.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                if (context.get(PrintService.SERVICE_NAME) == null) {
                    child.dispose();
                    done[0] = true;
                }
                return true;
            }
        });
        reg1.unregister();
    }

    public void testServiceExample() {
        BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
        ServiceRegistration reg = bundleContext.registerService(IPaletteService.class.getName(), (Object)new PaletteImpl(Color.BLUE), null);
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        Crayon crayon = new Crayon();
        ContextInjectionFactory.inject((Object)crayon, (IEclipseContext)context);
        crayon.draw();
        reg.unregister();
        crayon.draw();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Color {
        RED,
        BLUE,
        YELLOW,
        GREEN,
        ORANGE,
        PURPLE;

    }

    class Crayon {
        @Inject
        IPaletteService palette;
        String msg;

        Crayon() {
        }

        public void draw() {
            this.msg = this.palette == null ? "I'm out of ink!" : "My ink is  " + (Object)((Object)this.palette.getColor());
        }
    }

    static interface IPaletteService {
        public Color getColor();
    }

    class PaletteImpl
    implements IPaletteService {
        private final Color color;

        PaletteImpl(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }

    static class Printer {
        @Inject
        @Optional
        PrintService printer;

        Printer() {
        }

        public void print(String message) {
            if (this.printer != null) {
                this.printer.print(message);
            }
        }
    }
}

